/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListLiveMessageGroupMessagesRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="BeginTime")
    private Long beginTime;
    @Query
    @NameInMap(value="DataCenter")
    private String dataCenter;
    @Query
    @NameInMap(value="EndTime")
    private Long endTime;
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;
    @Query
    @NameInMap(value="MsgType")
    private Long msgType;
    @Query
    @NameInMap(value="NextPageToken")
    private Long nextPageToken;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true, maximum=50.0, minimum=10.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="SortType")
    @Validation(required=true, maximum=2.0, minimum=1.0)
    private Integer sortType;

    private ListLiveMessageGroupMessagesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.beginTime = builder.beginTime;
        this.dataCenter = builder.dataCenter;
        this.endTime = builder.endTime;
        this.groupId = builder.groupId;
        this.msgType = builder.msgType;
        this.nextPageToken = builder.nextPageToken;
        this.pageSize = builder.pageSize;
        this.sortType = builder.sortType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListLiveMessageGroupMessagesRequest create() {
        return ListLiveMessageGroupMessagesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public Long getBeginTime() {
        return this.beginTime;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Long getMsgType() {
        return this.msgType;
    }

    public Long getNextPageToken() {
        return this.nextPageToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getSortType() {
        return this.sortType;
    }

    public static final class Builder
    extends Request.Builder<ListLiveMessageGroupMessagesRequest, Builder> {
        private String appId;
        private Long beginTime;
        private String dataCenter;
        private Long endTime;
        private String groupId;
        private Long msgType;
        private Long nextPageToken;
        private Integer pageSize;
        private Integer sortType;

        private Builder() {
        }

        private Builder(ListLiveMessageGroupMessagesRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.beginTime = request.beginTime;
            this.dataCenter = request.dataCenter;
            this.endTime = request.endTime;
            this.groupId = request.groupId;
            this.msgType = request.msgType;
            this.nextPageToken = request.nextPageToken;
            this.pageSize = request.pageSize;
            this.sortType = request.sortType;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder beginTime(Long beginTime) {
            this.putQueryParameter("BeginTime", beginTime);
            this.beginTime = beginTime;
            return this;
        }

        public Builder dataCenter(String dataCenter) {
            this.putQueryParameter("DataCenter", dataCenter);
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder endTime(Long endTime) {
            this.putQueryParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder msgType(Long msgType) {
            this.putQueryParameter("MsgType", msgType);
            this.msgType = msgType;
            return this;
        }

        public Builder nextPageToken(Long nextPageToken) {
            this.putQueryParameter("NextPageToken", nextPageToken);
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder sortType(Integer sortType) {
            this.putQueryParameter("SortType", sortType);
            this.sortType = sortType;
            return this;
        }

        public ListLiveMessageGroupMessagesRequest build() {
            return new ListLiveMessageGroupMessagesRequest(this);
        }
    }
}

