/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListLiveMessageGroupUsersRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="DataCenter")
    private String dataCenter;
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;
    @Query
    @NameInMap(value="NextPageToken")
    private Long nextPageToken;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true, maximum=30.0, minimum=10.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="SortType")
    @Validation(required=true, maximum=2.0, minimum=1.0)
    private Integer sortType;

    private ListLiveMessageGroupUsersRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.dataCenter = builder.dataCenter;
        this.groupId = builder.groupId;
        this.nextPageToken = builder.nextPageToken;
        this.pageSize = builder.pageSize;
        this.sortType = builder.sortType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListLiveMessageGroupUsersRequest create() {
        return ListLiveMessageGroupUsersRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Long getNextPageToken() {
        return this.nextPageToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getSortType() {
        return this.sortType;
    }

    public static final class Builder
    extends Request.Builder<ListLiveMessageGroupUsersRequest, Builder> {
        private String appId;
        private String dataCenter;
        private String groupId;
        private Long nextPageToken;
        private Integer pageSize;
        private Integer sortType;

        private Builder() {
        }

        private Builder(ListLiveMessageGroupUsersRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.dataCenter = request.dataCenter;
            this.groupId = request.groupId;
            this.nextPageToken = request.nextPageToken;
            this.pageSize = request.pageSize;
            this.sortType = request.sortType;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder dataCenter(String dataCenter) {
            this.putQueryParameter("DataCenter", dataCenter);
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder nextPageToken(Long nextPageToken) {
            this.putQueryParameter("NextPageToken", nextPageToken);
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder sortType(Integer sortType) {
            this.putQueryParameter("SortType", sortType);
            this.sortType = sortType;
            return this;
        }

        public ListLiveMessageGroupUsersRequest build() {
            return new ListLiveMessageGroupUsersRequest(this);
        }
    }
}

