/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListLiveMessageGroupsRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="DataCenter")
    private String dataCenter;
    @Query
    @NameInMap(value="GroupStatus")
    private Integer groupStatus;
    @Query
    @NameInMap(value="NextPageToken")
    private Long nextPageToken;
    @Query
    @NameInMap(value="SortType")
    @Validation(required=true, maximum=2.0, minimum=1.0)
    private Integer sortType;

    private ListLiveMessageGroupsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.dataCenter = builder.dataCenter;
        this.groupStatus = builder.groupStatus;
        this.nextPageToken = builder.nextPageToken;
        this.sortType = builder.sortType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListLiveMessageGroupsRequest create() {
        return ListLiveMessageGroupsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public Integer getGroupStatus() {
        return this.groupStatus;
    }

    public Long getNextPageToken() {
        return this.nextPageToken;
    }

    public Integer getSortType() {
        return this.sortType;
    }

    public static final class Builder
    extends Request.Builder<ListLiveMessageGroupsRequest, Builder> {
        private String appId;
        private String dataCenter;
        private Integer groupStatus;
        private Long nextPageToken;
        private Integer sortType;

        private Builder() {
        }

        private Builder(ListLiveMessageGroupsRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.dataCenter = request.dataCenter;
            this.groupStatus = request.groupStatus;
            this.nextPageToken = request.nextPageToken;
            this.sortType = request.sortType;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder dataCenter(String dataCenter) {
            this.putQueryParameter("DataCenter", dataCenter);
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder groupStatus(Integer groupStatus) {
            this.putQueryParameter("GroupStatus", groupStatus);
            this.groupStatus = groupStatus;
            return this;
        }

        public Builder nextPageToken(Long nextPageToken) {
            this.putQueryParameter("NextPageToken", nextPageToken);
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Builder sortType(Integer sortType) {
            this.putQueryParameter("SortType", sortType);
            this.sortType = sortType;
            return this;
        }

        public ListLiveMessageGroupsRequest build() {
            return new ListLiveMessageGroupsRequest(this);
        }
    }
}

