/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListMessageGroupRequest
extends Request {
    @Body
    @NameInMap(value="AppId")
    private String appId;
    @Body
    @NameInMap(value="PageNum")
    @Validation(required=true)
    private Integer pageNum;
    @Body
    @NameInMap(value="PageSize")
    @Validation(required=true)
    private Integer pageSize;
    @Body
    @NameInMap(value="SortType")
    private Integer sortType;
    @Body
    @NameInMap(value="UserId")
    private String userId;

    private ListMessageGroupRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.pageNum = builder.pageNum;
        this.pageSize = builder.pageSize;
        this.sortType = builder.sortType;
        this.userId = builder.userId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListMessageGroupRequest create() {
        return ListMessageGroupRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getSortType() {
        return this.sortType;
    }

    public String getUserId() {
        return this.userId;
    }

    public static final class Builder
    extends Request.Builder<ListMessageGroupRequest, Builder> {
        private String appId;
        private Integer pageNum;
        private Integer pageSize;
        private Integer sortType;
        private String userId;

        private Builder() {
        }

        private Builder(ListMessageGroupRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.pageNum = request.pageNum;
            this.pageSize = request.pageSize;
            this.sortType = request.sortType;
            this.userId = request.userId;
        }

        public Builder appId(String appId) {
            this.putBodyParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder pageNum(Integer pageNum) {
            this.putBodyParameter("PageNum", pageNum);
            this.pageNum = pageNum;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putBodyParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder sortType(Integer sortType) {
            this.putBodyParameter("SortType", sortType);
            this.sortType = sortType;
            return this;
        }

        public Builder userId(String userId) {
            this.putBodyParameter("UserId", userId);
            this.userId = userId;
            return this;
        }

        public ListMessageGroupRequest build() {
            return new ListMessageGroupRequest(this);
        }
    }
}

