/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class ListMessageGroupUserByIdRequest
extends Request {
    @Body
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Body
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;
    @Body
    @NameInMap(value="UserIdList")
    @Validation(required=true)
    private List<String> userIdList;

    private ListMessageGroupUserByIdRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.groupId = builder.groupId;
        this.userIdList = builder.userIdList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListMessageGroupUserByIdRequest create() {
        return ListMessageGroupUserByIdRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<String> getUserIdList() {
        return this.userIdList;
    }

    public static final class Builder
    extends Request.Builder<ListMessageGroupUserByIdRequest, Builder> {
        private String appId;
        private String groupId;
        private List<String> userIdList;

        private Builder() {
        }

        private Builder(ListMessageGroupUserByIdRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.groupId = request.groupId;
            this.userIdList = request.userIdList;
        }

        public Builder appId(String appId) {
            this.putBodyParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putBodyParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder userIdList(List<String> userIdList) {
            String userIdListShrink = this.shrink(userIdList, "UserIdList", "simple");
            this.putBodyParameter("UserIdList", userIdListShrink);
            this.userIdList = userIdList;
            return this;
        }

        public ListMessageGroupUserByIdRequest build() {
            return new ListMessageGroupUserByIdRequest(this);
        }
    }
}

