/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class ModifyLiveMessageGroupBandRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="BannedAll")
    private Boolean bannedAll;
    @Query
    @NameInMap(value="BannnedUsers")
    private List<String> bannnedUsers;
    @Query
    @NameInMap(value="DataCenter")
    private String dataCenter;
    @Query
    @NameInMap(value="ExceptUsers")
    private List<String> exceptUsers;
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;

    private ModifyLiveMessageGroupBandRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.bannedAll = builder.bannedAll;
        this.bannnedUsers = builder.bannnedUsers;
        this.dataCenter = builder.dataCenter;
        this.exceptUsers = builder.exceptUsers;
        this.groupId = builder.groupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModifyLiveMessageGroupBandRequest create() {
        return ModifyLiveMessageGroupBandRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public Boolean getBannedAll() {
        return this.bannedAll;
    }

    public List<String> getBannnedUsers() {
        return this.bannnedUsers;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public List<String> getExceptUsers() {
        return this.exceptUsers;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public static final class Builder
    extends Request.Builder<ModifyLiveMessageGroupBandRequest, Builder> {
        private String appId;
        private Boolean bannedAll;
        private List<String> bannnedUsers;
        private String dataCenter;
        private List<String> exceptUsers;
        private String groupId;

        private Builder() {
        }

        private Builder(ModifyLiveMessageGroupBandRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.bannedAll = request.bannedAll;
            this.bannnedUsers = request.bannnedUsers;
            this.dataCenter = request.dataCenter;
            this.exceptUsers = request.exceptUsers;
            this.groupId = request.groupId;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder bannedAll(Boolean bannedAll) {
            this.putQueryParameter("BannedAll", bannedAll);
            this.bannedAll = bannedAll;
            return this;
        }

        public Builder bannnedUsers(List<String> bannnedUsers) {
            String bannnedUsersShrink = this.shrink(bannnedUsers, "BannnedUsers", "simple");
            this.putQueryParameter("BannnedUsers", bannnedUsersShrink);
            this.bannnedUsers = bannnedUsers;
            return this;
        }

        public Builder dataCenter(String dataCenter) {
            this.putQueryParameter("DataCenter", dataCenter);
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder exceptUsers(List<String> exceptUsers) {
            String exceptUsersShrink = this.shrink(exceptUsers, "ExceptUsers", "simple");
            this.putQueryParameter("ExceptUsers", exceptUsersShrink);
            this.exceptUsers = exceptUsers;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public ModifyLiveMessageGroupBandRequest build() {
            return new ModifyLiveMessageGroupBandRequest(this);
        }
    }
}

