/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ModifyShowListRequest
extends Request {
    @Query
    @NameInMap(value="CasterId")
    @Validation(required=true)
    private String casterId;
    @Query
    @NameInMap(value="HighPriorityShowId")
    private String highPriorityShowId;
    @Query
    @NameInMap(value="HighPriorityShowStartTime")
    private String highPriorityShowStartTime;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="RepeatTimes")
    private Integer repeatTimes;
    @Query
    @NameInMap(value="ShowId")
    private String showId;
    @Query
    @NameInMap(value="Spot")
    private Integer spot;

    private ModifyShowListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.casterId = builder.casterId;
        this.highPriorityShowId = builder.highPriorityShowId;
        this.highPriorityShowStartTime = builder.highPriorityShowStartTime;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.repeatTimes = builder.repeatTimes;
        this.showId = builder.showId;
        this.spot = builder.spot;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModifyShowListRequest create() {
        return ModifyShowListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCasterId() {
        return this.casterId;
    }

    public String getHighPriorityShowId() {
        return this.highPriorityShowId;
    }

    public String getHighPriorityShowStartTime() {
        return this.highPriorityShowStartTime;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public Integer getRepeatTimes() {
        return this.repeatTimes;
    }

    public String getShowId() {
        return this.showId;
    }

    public Integer getSpot() {
        return this.spot;
    }

    public static final class Builder
    extends Request.Builder<ModifyShowListRequest, Builder> {
        private String casterId;
        private String highPriorityShowId;
        private String highPriorityShowStartTime;
        private Long ownerId;
        private String regionId;
        private Integer repeatTimes;
        private String showId;
        private Integer spot;

        private Builder() {
        }

        private Builder(ModifyShowListRequest request) {
            super((Request)request);
            this.casterId = request.casterId;
            this.highPriorityShowId = request.highPriorityShowId;
            this.highPriorityShowStartTime = request.highPriorityShowStartTime;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.repeatTimes = request.repeatTimes;
            this.showId = request.showId;
            this.spot = request.spot;
        }

        public Builder casterId(String casterId) {
            this.putQueryParameter("CasterId", casterId);
            this.casterId = casterId;
            return this;
        }

        public Builder highPriorityShowId(String highPriorityShowId) {
            this.putQueryParameter("HighPriorityShowId", highPriorityShowId);
            this.highPriorityShowId = highPriorityShowId;
            return this;
        }

        public Builder highPriorityShowStartTime(String highPriorityShowStartTime) {
            this.putQueryParameter("HighPriorityShowStartTime", highPriorityShowStartTime);
            this.highPriorityShowStartTime = highPriorityShowStartTime;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder repeatTimes(Integer repeatTimes) {
            this.putQueryParameter("RepeatTimes", repeatTimes);
            this.repeatTimes = repeatTimes;
            return this;
        }

        public Builder showId(String showId) {
            this.putQueryParameter("ShowId", showId);
            this.showId = showId;
            return this;
        }

        public Builder spot(Integer spot) {
            this.putQueryParameter("Spot", spot);
            this.spot = spot;
            return this;
        }

        public ModifyShowListRequest build() {
            return new ModifyShowListRequest(this);
        }
    }
}

