/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class MuteGroupUserRequest
extends Request {
    @Body
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Body
    @NameInMap(value="BroadCastType")
    private Integer broadCastType;
    @Body
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;
    @Body
    @NameInMap(value="MuteTime")
    private Integer muteTime;
    @Body
    @NameInMap(value="MuteUserList")
    @Validation(required=true)
    private List<String> muteUserList;
    @Body
    @NameInMap(value="OperatorUserId")
    private String operatorUserId;

    private MuteGroupUserRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.broadCastType = builder.broadCastType;
        this.groupId = builder.groupId;
        this.muteTime = builder.muteTime;
        this.muteUserList = builder.muteUserList;
        this.operatorUserId = builder.operatorUserId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MuteGroupUserRequest create() {
        return MuteGroupUserRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public Integer getBroadCastType() {
        return this.broadCastType;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Integer getMuteTime() {
        return this.muteTime;
    }

    public List<String> getMuteUserList() {
        return this.muteUserList;
    }

    public String getOperatorUserId() {
        return this.operatorUserId;
    }

    public static final class Builder
    extends Request.Builder<MuteGroupUserRequest, Builder> {
        private String appId;
        private Integer broadCastType;
        private String groupId;
        private Integer muteTime;
        private List<String> muteUserList;
        private String operatorUserId;

        private Builder() {
        }

        private Builder(MuteGroupUserRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.broadCastType = request.broadCastType;
            this.groupId = request.groupId;
            this.muteTime = request.muteTime;
            this.muteUserList = request.muteUserList;
            this.operatorUserId = request.operatorUserId;
        }

        public Builder appId(String appId) {
            this.putBodyParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder broadCastType(Integer broadCastType) {
            this.putBodyParameter("BroadCastType", broadCastType);
            this.broadCastType = broadCastType;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putBodyParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder muteTime(Integer muteTime) {
            this.putBodyParameter("MuteTime", muteTime);
            this.muteTime = muteTime;
            return this;
        }

        public Builder muteUserList(List<String> muteUserList) {
            String muteUserListShrink = this.shrink(muteUserList, "MuteUserList", "simple");
            this.putBodyParameter("MuteUserList", muteUserListShrink);
            this.muteUserList = muteUserList;
            return this;
        }

        public Builder operatorUserId(String operatorUserId) {
            this.putBodyParameter("OperatorUserId", operatorUserId);
            this.operatorUserId = operatorUserId;
            return this;
        }

        public MuteGroupUserRequest build() {
            return new MuteGroupUserRequest(this);
        }
    }
}

