/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class RealTimeRecordCommandRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    @Validation(required=true)
    private String appName;
    @Query
    @NameInMap(value="Command")
    @Validation(required=true)
    private String command;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="StreamName")
    @Validation(required=true)
    private String streamName;

    private RealTimeRecordCommandRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.command = builder.command;
        this.domainName = builder.domainName;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.streamName = builder.streamName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RealTimeRecordCommandRequest create() {
        return RealTimeRecordCommandRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getCommand() {
        return this.command;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public static final class Builder
    extends Request.Builder<RealTimeRecordCommandRequest, Builder> {
        private String appName;
        private String command;
        private String domainName;
        private Long ownerId;
        private String regionId;
        private String streamName;

        private Builder() {
        }

        private Builder(RealTimeRecordCommandRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.command = request.command;
            this.domainName = request.domainName;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.streamName = request.streamName;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder command(String command) {
            this.putQueryParameter("Command", command);
            this.command = command;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder streamName(String streamName) {
            this.putQueryParameter("StreamName", streamName);
            this.streamName = streamName;
            return this;
        }

        public RealTimeRecordCommandRequest build() {
            return new RealTimeRecordCommandRequest(this);
        }
    }
}

