/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class RemoveLiveMessageGroupBandRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="DataCenter")
    private String dataCenter;
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;
    @Query
    @NameInMap(value="UnbannedUsers")
    @Validation(required=true)
    private List<String> unbannedUsers;

    private RemoveLiveMessageGroupBandRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.dataCenter = builder.dataCenter;
        this.groupId = builder.groupId;
        this.unbannedUsers = builder.unbannedUsers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RemoveLiveMessageGroupBandRequest create() {
        return RemoveLiveMessageGroupBandRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<String> getUnbannedUsers() {
        return this.unbannedUsers;
    }

    public static final class Builder
    extends Request.Builder<RemoveLiveMessageGroupBandRequest, Builder> {
        private String appId;
        private String dataCenter;
        private String groupId;
        private List<String> unbannedUsers;

        private Builder() {
        }

        private Builder(RemoveLiveMessageGroupBandRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.dataCenter = request.dataCenter;
            this.groupId = request.groupId;
            this.unbannedUsers = request.unbannedUsers;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder dataCenter(String dataCenter) {
            this.putQueryParameter("DataCenter", dataCenter);
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder unbannedUsers(List<String> unbannedUsers) {
            String unbannedUsersShrink = this.shrink(unbannedUsers, "UnbannedUsers", "simple");
            this.putQueryParameter("UnbannedUsers", unbannedUsersShrink);
            this.unbannedUsers = unbannedUsers;
            return this;
        }

        public RemoveLiveMessageGroupBandRequest build() {
            return new RemoveLiveMessageGroupBandRequest(this);
        }
    }
}

