/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class RemoveTerminalsRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="ChannelId")
    @Validation(required=true)
    private String channelId;
    @Query
    @NameInMap(value="TerminalIds")
    @Validation(required=true)
    private List<String> terminalIds;

    private RemoveTerminalsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.channelId = builder.channelId;
        this.terminalIds = builder.terminalIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RemoveTerminalsRequest create() {
        return RemoveTerminalsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public List<String> getTerminalIds() {
        return this.terminalIds;
    }

    public static final class Builder
    extends Request.Builder<RemoveTerminalsRequest, Builder> {
        private String appId;
        private String channelId;
        private List<String> terminalIds;

        private Builder() {
        }

        private Builder(RemoveTerminalsRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.channelId = request.channelId;
            this.terminalIds = request.terminalIds;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder channelId(String channelId) {
            this.putQueryParameter("ChannelId", channelId);
            this.channelId = channelId;
            return this;
        }

        public Builder terminalIds(List<String> terminalIds) {
            this.putQueryParameter("TerminalIds", terminalIds);
            this.terminalIds = terminalIds;
            return this;
        }

        public RemoveTerminalsRequest build() {
            return new RemoveTerminalsRequest(this);
        }
    }
}

