/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class SendLiveMessageGroupRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="Body")
    private String body;
    @Query
    @NameInMap(value="DataCenter")
    private String dataCenter;
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true, minLength=1)
    private String groupId;
    @Query
    @NameInMap(value="MsgTid")
    private String msgTid;
    @Query
    @NameInMap(value="MsgType")
    private Long msgType;
    @Query
    @NameInMap(value="NoCache")
    private Boolean noCache;
    @Query
    @NameInMap(value="NoStorage")
    private Boolean noStorage;
    @Query
    @NameInMap(value="SenderId")
    @Validation(required=true)
    private String senderId;
    @Query
    @NameInMap(value="SenderMetaInfo")
    private String senderMetaInfo;
    @Query
    @NameInMap(value="StaticsIncrease")
    private Long staticsIncrease;
    @Query
    @NameInMap(value="Weight")
    private Long weight;

    private SendLiveMessageGroupRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.body = builder.body;
        this.dataCenter = builder.dataCenter;
        this.groupId = builder.groupId;
        this.msgTid = builder.msgTid;
        this.msgType = builder.msgType;
        this.noCache = builder.noCache;
        this.noStorage = builder.noStorage;
        this.senderId = builder.senderId;
        this.senderMetaInfo = builder.senderMetaInfo;
        this.staticsIncrease = builder.staticsIncrease;
        this.weight = builder.weight;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SendLiveMessageGroupRequest create() {
        return SendLiveMessageGroupRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getBody() {
        return this.body;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getMsgTid() {
        return this.msgTid;
    }

    public Long getMsgType() {
        return this.msgType;
    }

    public Boolean getNoCache() {
        return this.noCache;
    }

    public Boolean getNoStorage() {
        return this.noStorage;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getSenderMetaInfo() {
        return this.senderMetaInfo;
    }

    public Long getStaticsIncrease() {
        return this.staticsIncrease;
    }

    public Long getWeight() {
        return this.weight;
    }

    public static final class Builder
    extends Request.Builder<SendLiveMessageGroupRequest, Builder> {
        private String appId;
        private String body;
        private String dataCenter;
        private String groupId;
        private String msgTid;
        private Long msgType;
        private Boolean noCache;
        private Boolean noStorage;
        private String senderId;
        private String senderMetaInfo;
        private Long staticsIncrease;
        private Long weight;

        private Builder() {
        }

        private Builder(SendLiveMessageGroupRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.body = request.body;
            this.dataCenter = request.dataCenter;
            this.groupId = request.groupId;
            this.msgTid = request.msgTid;
            this.msgType = request.msgType;
            this.noCache = request.noCache;
            this.noStorage = request.noStorage;
            this.senderId = request.senderId;
            this.senderMetaInfo = request.senderMetaInfo;
            this.staticsIncrease = request.staticsIncrease;
            this.weight = request.weight;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder body(String body) {
            this.putQueryParameter("Body", body);
            this.body = body;
            return this;
        }

        public Builder dataCenter(String dataCenter) {
            this.putQueryParameter("DataCenter", dataCenter);
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder msgTid(String msgTid) {
            this.putQueryParameter("MsgTid", msgTid);
            this.msgTid = msgTid;
            return this;
        }

        public Builder msgType(Long msgType) {
            this.putQueryParameter("MsgType", msgType);
            this.msgType = msgType;
            return this;
        }

        public Builder noCache(Boolean noCache) {
            this.putQueryParameter("NoCache", noCache);
            this.noCache = noCache;
            return this;
        }

        public Builder noStorage(Boolean noStorage) {
            this.putQueryParameter("NoStorage", noStorage);
            this.noStorage = noStorage;
            return this;
        }

        public Builder senderId(String senderId) {
            this.putQueryParameter("SenderId", senderId);
            this.senderId = senderId;
            return this;
        }

        public Builder senderMetaInfo(String senderMetaInfo) {
            this.putQueryParameter("SenderMetaInfo", senderMetaInfo);
            this.senderMetaInfo = senderMetaInfo;
            return this;
        }

        public Builder staticsIncrease(Long staticsIncrease) {
            this.putQueryParameter("StaticsIncrease", staticsIncrease);
            this.staticsIncrease = staticsIncrease;
            return this;
        }

        public Builder weight(Long weight) {
            this.putQueryParameter("Weight", weight);
            this.weight = weight;
            return this;
        }

        public SendLiveMessageGroupRequest build() {
            return new SendLiveMessageGroupRequest(this);
        }
    }
}

