/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class SendLiveMessageUserRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="Body")
    private String body;
    @Query
    @NameInMap(value="DataCenter")
    private String dataCenter;
    @Query
    @NameInMap(value="HighReliability")
    private Boolean highReliability;
    @Query
    @NameInMap(value="MsgTid")
    private String msgTid;
    @Query
    @NameInMap(value="MsgType")
    private Long msgType;
    @Query
    @NameInMap(value="ReceiverId")
    @Validation(required=true)
    private String receiverId;
    @Query
    @NameInMap(value="SenderId")
    @Validation(required=true)
    private String senderId;
    @Query
    @NameInMap(value="SenderInfo")
    private String senderInfo;
    @Query
    @NameInMap(value="Storage")
    private Boolean storage;

    private SendLiveMessageUserRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.body = builder.body;
        this.dataCenter = builder.dataCenter;
        this.highReliability = builder.highReliability;
        this.msgTid = builder.msgTid;
        this.msgType = builder.msgType;
        this.receiverId = builder.receiverId;
        this.senderId = builder.senderId;
        this.senderInfo = builder.senderInfo;
        this.storage = builder.storage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SendLiveMessageUserRequest create() {
        return SendLiveMessageUserRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getBody() {
        return this.body;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public Boolean getHighReliability() {
        return this.highReliability;
    }

    public String getMsgTid() {
        return this.msgTid;
    }

    public Long getMsgType() {
        return this.msgType;
    }

    public String getReceiverId() {
        return this.receiverId;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getSenderInfo() {
        return this.senderInfo;
    }

    public Boolean getStorage() {
        return this.storage;
    }

    public static final class Builder
    extends Request.Builder<SendLiveMessageUserRequest, Builder> {
        private String appId;
        private String body;
        private String dataCenter;
        private Boolean highReliability;
        private String msgTid;
        private Long msgType;
        private String receiverId;
        private String senderId;
        private String senderInfo;
        private Boolean storage;

        private Builder() {
        }

        private Builder(SendLiveMessageUserRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.body = request.body;
            this.dataCenter = request.dataCenter;
            this.highReliability = request.highReliability;
            this.msgTid = request.msgTid;
            this.msgType = request.msgType;
            this.receiverId = request.receiverId;
            this.senderId = request.senderId;
            this.senderInfo = request.senderInfo;
            this.storage = request.storage;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder body(String body) {
            this.putQueryParameter("Body", body);
            this.body = body;
            return this;
        }

        public Builder dataCenter(String dataCenter) {
            this.putQueryParameter("DataCenter", dataCenter);
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder highReliability(Boolean highReliability) {
            this.putQueryParameter("HighReliability", highReliability);
            this.highReliability = highReliability;
            return this;
        }

        public Builder msgTid(String msgTid) {
            this.putQueryParameter("MsgTid", msgTid);
            this.msgTid = msgTid;
            return this;
        }

        public Builder msgType(Long msgType) {
            this.putQueryParameter("MsgType", msgType);
            this.msgType = msgType;
            return this;
        }

        public Builder receiverId(String receiverId) {
            this.putQueryParameter("ReceiverId", receiverId);
            this.receiverId = receiverId;
            return this;
        }

        public Builder senderId(String senderId) {
            this.putQueryParameter("SenderId", senderId);
            this.senderId = senderId;
            return this;
        }

        public Builder senderInfo(String senderInfo) {
            this.putQueryParameter("SenderInfo", senderInfo);
            this.senderInfo = senderInfo;
            return this;
        }

        public Builder storage(Boolean storage) {
            this.putQueryParameter("Storage", storage);
            this.storage = storage;
            return this;
        }

        public SendLiveMessageUserRequest build() {
            return new SendLiveMessageUserRequest(this);
        }
    }
}

