/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class SendMessageToGroupUsersRequest
extends Request {
    @Body
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Body
    @NameInMap(value="Data")
    @Validation(required=true)
    private String data;
    @Body
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;
    @Body
    @NameInMap(value="OperatorUserId")
    @Validation(required=true)
    private String operatorUserId;
    @Body
    @NameInMap(value="ReceiverIdList")
    private List<String> receiverIdList;
    @Query
    @NameInMap(value="SkipAudit")
    private Boolean skipAudit;
    @Body
    @NameInMap(value="Type")
    @Validation(required=true)
    private Integer type;

    private SendMessageToGroupUsersRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.data = builder.data;
        this.groupId = builder.groupId;
        this.operatorUserId = builder.operatorUserId;
        this.receiverIdList = builder.receiverIdList;
        this.skipAudit = builder.skipAudit;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SendMessageToGroupUsersRequest create() {
        return SendMessageToGroupUsersRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getData() {
        return this.data;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getOperatorUserId() {
        return this.operatorUserId;
    }

    public List<String> getReceiverIdList() {
        return this.receiverIdList;
    }

    public Boolean getSkipAudit() {
        return this.skipAudit;
    }

    public Integer getType() {
        return this.type;
    }

    public static final class Builder
    extends Request.Builder<SendMessageToGroupUsersRequest, Builder> {
        private String appId;
        private String data;
        private String groupId;
        private String operatorUserId;
        private List<String> receiverIdList;
        private Boolean skipAudit;
        private Integer type;

        private Builder() {
        }

        private Builder(SendMessageToGroupUsersRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.data = request.data;
            this.groupId = request.groupId;
            this.operatorUserId = request.operatorUserId;
            this.receiverIdList = request.receiverIdList;
            this.skipAudit = request.skipAudit;
            this.type = request.type;
        }

        public Builder appId(String appId) {
            this.putBodyParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder data(String data) {
            this.putBodyParameter("Data", data);
            this.data = data;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putBodyParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder operatorUserId(String operatorUserId) {
            this.putBodyParameter("OperatorUserId", operatorUserId);
            this.operatorUserId = operatorUserId;
            return this;
        }

        public Builder receiverIdList(List<String> receiverIdList) {
            String receiverIdListShrink = this.shrink(receiverIdList, "ReceiverIdList", "simple");
            this.putBodyParameter("ReceiverIdList", receiverIdListShrink);
            this.receiverIdList = receiverIdList;
            return this;
        }

        public Builder skipAudit(Boolean skipAudit) {
            this.putQueryParameter("SkipAudit", skipAudit);
            this.skipAudit = skipAudit;
            return this;
        }

        public Builder type(Integer type) {
            this.putBodyParameter("Type", type);
            this.type = type;
            return this;
        }

        public SendMessageToGroupUsersRequest build() {
            return new SendMessageToGroupUsersRequest(this);
        }
    }
}

