/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class SetLiveEdgeTransferRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    private String appName;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="HttpDns")
    private String httpDns;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="StreamName")
    private String streamName;
    @Query
    @NameInMap(value="TargetDomainList")
    private String targetDomainList;
    @Query
    @NameInMap(value="TransferArgs")
    private String transferArgs;

    private SetLiveEdgeTransferRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.domainName = builder.domainName;
        this.httpDns = builder.httpDns;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.streamName = builder.streamName;
        this.targetDomainList = builder.targetDomainList;
        this.transferArgs = builder.transferArgs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SetLiveEdgeTransferRequest create() {
        return SetLiveEdgeTransferRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getHttpDns() {
        return this.httpDns;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getTargetDomainList() {
        return this.targetDomainList;
    }

    public String getTransferArgs() {
        return this.transferArgs;
    }

    public static final class Builder
    extends Request.Builder<SetLiveEdgeTransferRequest, Builder> {
        private String appName;
        private String domainName;
        private String httpDns;
        private Long ownerId;
        private String regionId;
        private String streamName;
        private String targetDomainList;
        private String transferArgs;

        private Builder() {
        }

        private Builder(SetLiveEdgeTransferRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.domainName = request.domainName;
            this.httpDns = request.httpDns;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.streamName = request.streamName;
            this.targetDomainList = request.targetDomainList;
            this.transferArgs = request.transferArgs;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder httpDns(String httpDns) {
            this.putQueryParameter("HttpDns", httpDns);
            this.httpDns = httpDns;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder streamName(String streamName) {
            this.putQueryParameter("StreamName", streamName);
            this.streamName = streamName;
            return this;
        }

        public Builder targetDomainList(String targetDomainList) {
            this.putQueryParameter("TargetDomainList", targetDomainList);
            this.targetDomainList = targetDomainList;
            return this;
        }

        public Builder transferArgs(String transferArgs) {
            this.putQueryParameter("TransferArgs", transferArgs);
            this.transferArgs = transferArgs;
            return this;
        }

        public SetLiveEdgeTransferRequest build() {
            return new SetLiveEdgeTransferRequest(this);
        }
    }
}

