/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class SetLiveStreamBlockRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    @Validation(required=true)
    private String appName;
    @Query
    @NameInMap(value="BlockType")
    @Validation(required=true)
    private String blockType;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="LocationList")
    @Validation(required=true)
    private String locationList;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="ReleaseTime")
    private String releaseTime;
    @Query
    @NameInMap(value="StreamName")
    @Validation(required=true)
    private String streamName;

    private SetLiveStreamBlockRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.blockType = builder.blockType;
        this.domainName = builder.domainName;
        this.locationList = builder.locationList;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.releaseTime = builder.releaseTime;
        this.streamName = builder.streamName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SetLiveStreamBlockRequest create() {
        return SetLiveStreamBlockRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getBlockType() {
        return this.blockType;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getLocationList() {
        return this.locationList;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getReleaseTime() {
        return this.releaseTime;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public static final class Builder
    extends Request.Builder<SetLiveStreamBlockRequest, Builder> {
        private String appName;
        private String blockType;
        private String domainName;
        private String locationList;
        private Long ownerId;
        private String regionId;
        private String releaseTime;
        private String streamName;

        private Builder() {
        }

        private Builder(SetLiveStreamBlockRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.blockType = request.blockType;
            this.domainName = request.domainName;
            this.locationList = request.locationList;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.releaseTime = request.releaseTime;
            this.streamName = request.streamName;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder blockType(String blockType) {
            this.putQueryParameter("BlockType", blockType);
            this.blockType = blockType;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder locationList(String locationList) {
            this.putQueryParameter("LocationList", locationList);
            this.locationList = locationList;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder releaseTime(String releaseTime) {
            this.putQueryParameter("ReleaseTime", releaseTime);
            this.releaseTime = releaseTime;
            return this;
        }

        public Builder streamName(String streamName) {
            this.putQueryParameter("StreamName", streamName);
            this.streamName = streamName;
            return this;
        }

        public SetLiveStreamBlockRequest build() {
            return new SetLiveStreamBlockRequest(this);
        }
    }
}

