/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class StartRtcCloudRecordingRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="ChannelId")
    @Validation(required=true)
    private String channelId;
    @Query
    @NameInMap(value="MixLayoutParams")
    private MixLayoutParams mixLayoutParams;
    @Query
    @NameInMap(value="MixTranscodeParams")
    private MixTranscodeParams mixTranscodeParams;
    @Query
    @NameInMap(value="NotifyUrl")
    private String notifyUrl;
    @Query
    @NameInMap(value="RecordParams")
    @Validation(required=true)
    private RecordParams recordParams;
    @Query
    @NameInMap(value="StorageParams")
    @Validation(required=true)
    private StorageParams storageParams;
    @Query
    @NameInMap(value="SubscribeParams")
    @Validation(required=true)
    private SubscribeParams subscribeParams;

    private StartRtcCloudRecordingRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.channelId = builder.channelId;
        this.mixLayoutParams = builder.mixLayoutParams;
        this.mixTranscodeParams = builder.mixTranscodeParams;
        this.notifyUrl = builder.notifyUrl;
        this.recordParams = builder.recordParams;
        this.storageParams = builder.storageParams;
        this.subscribeParams = builder.subscribeParams;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StartRtcCloudRecordingRequest create() {
        return StartRtcCloudRecordingRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public MixLayoutParams getMixLayoutParams() {
        return this.mixLayoutParams;
    }

    public MixTranscodeParams getMixTranscodeParams() {
        return this.mixTranscodeParams;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public RecordParams getRecordParams() {
        return this.recordParams;
    }

    public StorageParams getStorageParams() {
        return this.storageParams;
    }

    public SubscribeParams getSubscribeParams() {
        return this.subscribeParams;
    }

    public static class SubscribeParams
    extends TeaModel {
        @NameInMap(value="SubscribeUserIdList")
        @Validation(required=true)
        private List<SubscribeUserIdList> subscribeUserIdList;

        private SubscribeParams(Builder builder) {
            this.subscribeUserIdList = builder.subscribeUserIdList;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static SubscribeParams create() {
            return SubscribeParams.builder().build();
        }

        public List<SubscribeUserIdList> getSubscribeUserIdList() {
            return this.subscribeUserIdList;
        }

        public static final class Builder {
            private List<SubscribeUserIdList> subscribeUserIdList;

            private Builder() {
            }

            private Builder(SubscribeParams model) {
                this.subscribeUserIdList = model.subscribeUserIdList;
            }

            public Builder subscribeUserIdList(List<SubscribeUserIdList> subscribeUserIdList) {
                this.subscribeUserIdList = subscribeUserIdList;
                return this;
            }

            public SubscribeParams build() {
                return new SubscribeParams(this);
            }
        }
    }

    public static class SubscribeUserIdList
    extends TeaModel {
        @NameInMap(value="SourceType")
        private Integer sourceType;
        @NameInMap(value="StreamType")
        private Integer streamType;
        @NameInMap(value="UserId")
        @Validation(required=true)
        private String userId;

        private SubscribeUserIdList(Builder builder) {
            this.sourceType = builder.sourceType;
            this.streamType = builder.streamType;
            this.userId = builder.userId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static SubscribeUserIdList create() {
            return SubscribeUserIdList.builder().build();
        }

        public Integer getSourceType() {
            return this.sourceType;
        }

        public Integer getStreamType() {
            return this.streamType;
        }

        public String getUserId() {
            return this.userId;
        }

        public static final class Builder {
            private Integer sourceType;
            private Integer streamType;
            private String userId;

            private Builder() {
            }

            private Builder(SubscribeUserIdList model) {
                this.sourceType = model.sourceType;
                this.streamType = model.streamType;
                this.userId = model.userId;
            }

            public Builder sourceType(Integer sourceType) {
                this.sourceType = sourceType;
                return this;
            }

            public Builder streamType(Integer streamType) {
                this.streamType = streamType;
                return this;
            }

            public Builder userId(String userId) {
                this.userId = userId;
                return this;
            }

            public SubscribeUserIdList build() {
                return new SubscribeUserIdList(this);
            }
        }
    }

    public static class StorageParams
    extends TeaModel {
        @NameInMap(value="FileInfo")
        private List<FileInfo> fileInfo;
        @NameInMap(value="OSSParams")
        private OSSParams OSSParams;
        @NameInMap(value="StorageType")
        @Validation(required=true)
        private Integer storageType;

        private StorageParams(Builder builder) {
            this.fileInfo = builder.fileInfo;
            this.OSSParams = builder.OSSParams;
            this.storageType = builder.storageType;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static StorageParams create() {
            return StorageParams.builder().build();
        }

        public List<FileInfo> getFileInfo() {
            return this.fileInfo;
        }

        public OSSParams getOSSParams() {
            return this.OSSParams;
        }

        public Integer getStorageType() {
            return this.storageType;
        }

        public static final class Builder {
            private List<FileInfo> fileInfo;
            private OSSParams OSSParams;
            private Integer storageType;

            private Builder() {
            }

            private Builder(StorageParams model) {
                this.fileInfo = model.fileInfo;
                this.OSSParams = model.OSSParams;
                this.storageType = model.storageType;
            }

            public Builder fileInfo(List<FileInfo> fileInfo) {
                this.fileInfo = fileInfo;
                return this;
            }

            public Builder OSSParams(OSSParams OSSParams2) {
                this.OSSParams = OSSParams2;
                return this;
            }

            public Builder storageType(Integer storageType) {
                this.storageType = storageType;
                return this;
            }

            public StorageParams build() {
                return new StorageParams(this);
            }
        }
    }

    public static class OSSParams
    extends TeaModel {
        @NameInMap(value="OSSBucket")
        @Validation(required=true)
        private String OSSBucket;
        @NameInMap(value="OSSEndpoint")
        @Validation(required=true)
        private String OSSEndpoint;

        private OSSParams(Builder builder) {
            this.OSSBucket = builder.OSSBucket;
            this.OSSEndpoint = builder.OSSEndpoint;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static OSSParams create() {
            return OSSParams.builder().build();
        }

        public String getOSSBucket() {
            return this.OSSBucket;
        }

        public String getOSSEndpoint() {
            return this.OSSEndpoint;
        }

        public static final class Builder {
            private String OSSBucket;
            private String OSSEndpoint;

            private Builder() {
            }

            private Builder(OSSParams model) {
                this.OSSBucket = model.OSSBucket;
                this.OSSEndpoint = model.OSSEndpoint;
            }

            public Builder OSSBucket(String OSSBucket) {
                this.OSSBucket = OSSBucket;
                return this;
            }

            public Builder OSSEndpoint(String OSSEndpoint) {
                this.OSSEndpoint = OSSEndpoint;
                return this;
            }

            public OSSParams build() {
                return new OSSParams(this);
            }
        }
    }

    public static class FileInfo
    extends TeaModel {
        @NameInMap(value="FileNamePattern")
        private String fileNamePattern;
        @NameInMap(value="Format")
        @Validation(required=true)
        private String format;
        @NameInMap(value="SliceNamePattern")
        private String sliceNamePattern;

        private FileInfo(Builder builder) {
            this.fileNamePattern = builder.fileNamePattern;
            this.format = builder.format;
            this.sliceNamePattern = builder.sliceNamePattern;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static FileInfo create() {
            return FileInfo.builder().build();
        }

        public String getFileNamePattern() {
            return this.fileNamePattern;
        }

        public String getFormat() {
            return this.format;
        }

        public String getSliceNamePattern() {
            return this.sliceNamePattern;
        }

        public static final class Builder {
            private String fileNamePattern;
            private String format;
            private String sliceNamePattern;

            private Builder() {
            }

            private Builder(FileInfo model) {
                this.fileNamePattern = model.fileNamePattern;
                this.format = model.format;
                this.sliceNamePattern = model.sliceNamePattern;
            }

            public Builder fileNamePattern(String fileNamePattern) {
                this.fileNamePattern = fileNamePattern;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder sliceNamePattern(String sliceNamePattern) {
                this.sliceNamePattern = sliceNamePattern;
                return this;
            }

            public FileInfo build() {
                return new FileInfo(this);
            }
        }
    }

    public static class RecordParams
    extends TeaModel {
        @NameInMap(value="MaxFileDuration")
        @Validation(maximum=7200.0, minimum=180.0)
        private Long maxFileDuration;
        @NameInMap(value="RecordMode")
        @Validation(required=true)
        private Integer recordMode;
        @NameInMap(value="StreamType")
        private Integer streamType;

        private RecordParams(Builder builder) {
            this.maxFileDuration = builder.maxFileDuration;
            this.recordMode = builder.recordMode;
            this.streamType = builder.streamType;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static RecordParams create() {
            return RecordParams.builder().build();
        }

        public Long getMaxFileDuration() {
            return this.maxFileDuration;
        }

        public Integer getRecordMode() {
            return this.recordMode;
        }

        public Integer getStreamType() {
            return this.streamType;
        }

        public static final class Builder {
            private Long maxFileDuration;
            private Integer recordMode;
            private Integer streamType;

            private Builder() {
            }

            private Builder(RecordParams model) {
                this.maxFileDuration = model.maxFileDuration;
                this.recordMode = model.recordMode;
                this.streamType = model.streamType;
            }

            public Builder maxFileDuration(Long maxFileDuration) {
                this.maxFileDuration = maxFileDuration;
                return this;
            }

            public Builder recordMode(Integer recordMode) {
                this.recordMode = recordMode;
                return this;
            }

            public Builder streamType(Integer streamType) {
                this.streamType = streamType;
                return this;
            }

            public RecordParams build() {
                return new RecordParams(this);
            }
        }
    }

    public static class MixTranscodeParams
    extends TeaModel {
        @NameInMap(value="AudioBitrate")
        @Validation(required=true, maximum=500.0, minimum=8.0)
        private Long audioBitrate;
        @NameInMap(value="AudioChannels")
        @Validation(required=true)
        private Integer audioChannels;
        @NameInMap(value="AudioSampleRate")
        @Validation(required=true)
        private Long audioSampleRate;
        @NameInMap(value="FrameFillType")
        private Integer frameFillType;
        @NameInMap(value="VideoBitrate")
        @Validation(maximum=10000.0, minimum=1.0)
        private Integer videoBitrate;
        @NameInMap(value="VideoCodec")
        private String videoCodec;
        @NameInMap(value="VideoFramerate")
        @Validation(maximum=60.0, minimum=1.0)
        private Integer videoFramerate;
        @NameInMap(value="VideoGop")
        @Validation(maximum=60.0, minimum=1.0)
        private Integer videoGop;
        @NameInMap(value="VideoHeight")
        @Validation(maximum=1920.0)
        private Integer videoHeight;
        @NameInMap(value="VideoWidth")
        @Validation(maximum=1920.0)
        private Integer videoWidth;

        private MixTranscodeParams(Builder builder) {
            this.audioBitrate = builder.audioBitrate;
            this.audioChannels = builder.audioChannels;
            this.audioSampleRate = builder.audioSampleRate;
            this.frameFillType = builder.frameFillType;
            this.videoBitrate = builder.videoBitrate;
            this.videoCodec = builder.videoCodec;
            this.videoFramerate = builder.videoFramerate;
            this.videoGop = builder.videoGop;
            this.videoHeight = builder.videoHeight;
            this.videoWidth = builder.videoWidth;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static MixTranscodeParams create() {
            return MixTranscodeParams.builder().build();
        }

        public Long getAudioBitrate() {
            return this.audioBitrate;
        }

        public Integer getAudioChannels() {
            return this.audioChannels;
        }

        public Long getAudioSampleRate() {
            return this.audioSampleRate;
        }

        public Integer getFrameFillType() {
            return this.frameFillType;
        }

        public Integer getVideoBitrate() {
            return this.videoBitrate;
        }

        public String getVideoCodec() {
            return this.videoCodec;
        }

        public Integer getVideoFramerate() {
            return this.videoFramerate;
        }

        public Integer getVideoGop() {
            return this.videoGop;
        }

        public Integer getVideoHeight() {
            return this.videoHeight;
        }

        public Integer getVideoWidth() {
            return this.videoWidth;
        }

        public static final class Builder {
            private Long audioBitrate;
            private Integer audioChannels;
            private Long audioSampleRate;
            private Integer frameFillType;
            private Integer videoBitrate;
            private String videoCodec;
            private Integer videoFramerate;
            private Integer videoGop;
            private Integer videoHeight;
            private Integer videoWidth;

            private Builder() {
            }

            private Builder(MixTranscodeParams model) {
                this.audioBitrate = model.audioBitrate;
                this.audioChannels = model.audioChannels;
                this.audioSampleRate = model.audioSampleRate;
                this.frameFillType = model.frameFillType;
                this.videoBitrate = model.videoBitrate;
                this.videoCodec = model.videoCodec;
                this.videoFramerate = model.videoFramerate;
                this.videoGop = model.videoGop;
                this.videoHeight = model.videoHeight;
                this.videoWidth = model.videoWidth;
            }

            public Builder audioBitrate(Long audioBitrate) {
                this.audioBitrate = audioBitrate;
                return this;
            }

            public Builder audioChannels(Integer audioChannels) {
                this.audioChannels = audioChannels;
                return this;
            }

            public Builder audioSampleRate(Long audioSampleRate) {
                this.audioSampleRate = audioSampleRate;
                return this;
            }

            public Builder frameFillType(Integer frameFillType) {
                this.frameFillType = frameFillType;
                return this;
            }

            public Builder videoBitrate(Integer videoBitrate) {
                this.videoBitrate = videoBitrate;
                return this;
            }

            public Builder videoCodec(String videoCodec) {
                this.videoCodec = videoCodec;
                return this;
            }

            public Builder videoFramerate(Integer videoFramerate) {
                this.videoFramerate = videoFramerate;
                return this;
            }

            public Builder videoGop(Integer videoGop) {
                this.videoGop = videoGop;
                return this;
            }

            public Builder videoHeight(Integer videoHeight) {
                this.videoHeight = videoHeight;
                return this;
            }

            public Builder videoWidth(Integer videoWidth) {
                this.videoWidth = videoWidth;
                return this;
            }

            public MixTranscodeParams build() {
                return new MixTranscodeParams(this);
            }
        }
    }

    public static class MixLayoutParams
    extends TeaModel {
        @NameInMap(value="MixBackground")
        private MixBackground mixBackground;
        @NameInMap(value="UserPanes")
        private List<UserPanes> userPanes;

        private MixLayoutParams(Builder builder) {
            this.mixBackground = builder.mixBackground;
            this.userPanes = builder.userPanes;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static MixLayoutParams create() {
            return MixLayoutParams.builder().build();
        }

        public MixBackground getMixBackground() {
            return this.mixBackground;
        }

        public List<UserPanes> getUserPanes() {
            return this.userPanes;
        }

        public static final class Builder {
            private MixBackground mixBackground;
            private List<UserPanes> userPanes;

            private Builder() {
            }

            private Builder(MixLayoutParams model) {
                this.mixBackground = model.mixBackground;
                this.userPanes = model.userPanes;
            }

            public Builder mixBackground(MixBackground mixBackground) {
                this.mixBackground = mixBackground;
                return this;
            }

            public Builder userPanes(List<UserPanes> userPanes) {
                this.userPanes = userPanes;
                return this;
            }

            public MixLayoutParams build() {
                return new MixLayoutParams(this);
            }
        }
    }

    public static class UserPanes
    extends TeaModel {
        @NameInMap(value="Height")
        private String height;
        @NameInMap(value="SourceType")
        private Integer sourceType;
        @NameInMap(value="SubBackground")
        private SubBackground subBackground;
        @NameInMap(value="UserId")
        private String userId;
        @NameInMap(value="Width")
        private String width;
        @NameInMap(value="X")
        private String x;
        @NameInMap(value="Y")
        private String y;
        @NameInMap(value="ZOrder")
        private Integer zOrder;

        private UserPanes(Builder builder) {
            this.height = builder.height;
            this.sourceType = builder.sourceType;
            this.subBackground = builder.subBackground;
            this.userId = builder.userId;
            this.width = builder.width;
            this.x = builder.x;
            this.y = builder.y;
            this.zOrder = builder.zOrder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static UserPanes create() {
            return UserPanes.builder().build();
        }

        public String getHeight() {
            return this.height;
        }

        public Integer getSourceType() {
            return this.sourceType;
        }

        public SubBackground getSubBackground() {
            return this.subBackground;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getWidth() {
            return this.width;
        }

        public String getX() {
            return this.x;
        }

        public String getY() {
            return this.y;
        }

        public Integer getZOrder() {
            return this.zOrder;
        }

        public static final class Builder {
            private String height;
            private Integer sourceType;
            private SubBackground subBackground;
            private String userId;
            private String width;
            private String x;
            private String y;
            private Integer zOrder;

            private Builder() {
            }

            private Builder(UserPanes model) {
                this.height = model.height;
                this.sourceType = model.sourceType;
                this.subBackground = model.subBackground;
                this.userId = model.userId;
                this.width = model.width;
                this.x = model.x;
                this.y = model.y;
                this.zOrder = model.zOrder;
            }

            public Builder height(String height) {
                this.height = height;
                return this;
            }

            public Builder sourceType(Integer sourceType) {
                this.sourceType = sourceType;
                return this;
            }

            public Builder subBackground(SubBackground subBackground) {
                this.subBackground = subBackground;
                return this;
            }

            public Builder userId(String userId) {
                this.userId = userId;
                return this;
            }

            public Builder width(String width) {
                this.width = width;
                return this;
            }

            public Builder x(String x) {
                this.x = x;
                return this;
            }

            public Builder y(String y) {
                this.y = y;
                return this;
            }

            public Builder zOrder(Integer zOrder) {
                this.zOrder = zOrder;
                return this;
            }

            public UserPanes build() {
                return new UserPanes(this);
            }
        }
    }

    public static class SubBackground
    extends TeaModel {
        @NameInMap(value="RenderMode")
        private Integer renderMode;
        @NameInMap(value="Url")
        @Validation(maxLength=2048)
        private String url;

        private SubBackground(Builder builder) {
            this.renderMode = builder.renderMode;
            this.url = builder.url;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static SubBackground create() {
            return SubBackground.builder().build();
        }

        public Integer getRenderMode() {
            return this.renderMode;
        }

        public String getUrl() {
            return this.url;
        }

        public static final class Builder {
            private Integer renderMode;
            private String url;

            private Builder() {
            }

            private Builder(SubBackground model) {
                this.renderMode = model.renderMode;
                this.url = model.url;
            }

            public Builder renderMode(Integer renderMode) {
                this.renderMode = renderMode;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public SubBackground build() {
                return new SubBackground(this);
            }
        }
    }

    public static class MixBackground
    extends TeaModel {
        @NameInMap(value="RenderMode")
        private Integer renderMode;
        @NameInMap(value="Url")
        @Validation(maxLength=2048)
        private String url;

        private MixBackground(Builder builder) {
            this.renderMode = builder.renderMode;
            this.url = builder.url;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static MixBackground create() {
            return MixBackground.builder().build();
        }

        public Integer getRenderMode() {
            return this.renderMode;
        }

        public String getUrl() {
            return this.url;
        }

        public static final class Builder {
            private Integer renderMode;
            private String url;

            private Builder() {
            }

            private Builder(MixBackground model) {
                this.renderMode = model.renderMode;
                this.url = model.url;
            }

            public Builder renderMode(Integer renderMode) {
                this.renderMode = renderMode;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public MixBackground build() {
                return new MixBackground(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<StartRtcCloudRecordingRequest, Builder> {
        private String appId;
        private String channelId;
        private MixLayoutParams mixLayoutParams;
        private MixTranscodeParams mixTranscodeParams;
        private String notifyUrl;
        private RecordParams recordParams;
        private StorageParams storageParams;
        private SubscribeParams subscribeParams;

        private Builder() {
        }

        private Builder(StartRtcCloudRecordingRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.channelId = request.channelId;
            this.mixLayoutParams = request.mixLayoutParams;
            this.mixTranscodeParams = request.mixTranscodeParams;
            this.notifyUrl = request.notifyUrl;
            this.recordParams = request.recordParams;
            this.storageParams = request.storageParams;
            this.subscribeParams = request.subscribeParams;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder channelId(String channelId) {
            this.putQueryParameter("ChannelId", channelId);
            this.channelId = channelId;
            return this;
        }

        public Builder mixLayoutParams(MixLayoutParams mixLayoutParams) {
            String mixLayoutParamsShrink = this.shrink((Object)mixLayoutParams, "MixLayoutParams", "json");
            this.putQueryParameter("MixLayoutParams", mixLayoutParamsShrink);
            this.mixLayoutParams = mixLayoutParams;
            return this;
        }

        public Builder mixTranscodeParams(MixTranscodeParams mixTranscodeParams) {
            String mixTranscodeParamsShrink = this.shrink((Object)mixTranscodeParams, "MixTranscodeParams", "json");
            this.putQueryParameter("MixTranscodeParams", mixTranscodeParamsShrink);
            this.mixTranscodeParams = mixTranscodeParams;
            return this;
        }

        public Builder notifyUrl(String notifyUrl) {
            this.putQueryParameter("NotifyUrl", notifyUrl);
            this.notifyUrl = notifyUrl;
            return this;
        }

        public Builder recordParams(RecordParams recordParams) {
            String recordParamsShrink = this.shrink((Object)recordParams, "RecordParams", "json");
            this.putQueryParameter("RecordParams", recordParamsShrink);
            this.recordParams = recordParams;
            return this;
        }

        public Builder storageParams(StorageParams storageParams) {
            String storageParamsShrink = this.shrink((Object)storageParams, "StorageParams", "json");
            this.putQueryParameter("StorageParams", storageParamsShrink);
            this.storageParams = storageParams;
            return this;
        }

        public Builder subscribeParams(SubscribeParams subscribeParams) {
            String subscribeParamsShrink = this.shrink((Object)subscribeParams, "SubscribeParams", "json");
            this.putQueryParameter("SubscribeParams", subscribeParamsShrink);
            this.subscribeParams = subscribeParams;
            return this;
        }

        public StartRtcCloudRecordingRequest build() {
            return new StartRtcCloudRecordingRequest(this);
        }
    }
}

