/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateCasterSceneAudioRequest
extends Request {
    @Query
    @NameInMap(value="AudioLayer")
    private List<AudioLayer> audioLayer;
    @Query
    @NameInMap(value="CasterId")
    @Validation(required=true)
    private String casterId;
    @Query
    @NameInMap(value="FollowEnable")
    private Integer followEnable;
    @Query
    @NameInMap(value="MixList")
    private List<String> mixList;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="SceneId")
    @Validation(required=true)
    private String sceneId;

    private UpdateCasterSceneAudioRequest(Builder builder) {
        super((Request.Builder)builder);
        this.audioLayer = builder.audioLayer;
        this.casterId = builder.casterId;
        this.followEnable = builder.followEnable;
        this.mixList = builder.mixList;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.sceneId = builder.sceneId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateCasterSceneAudioRequest create() {
        return UpdateCasterSceneAudioRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<AudioLayer> getAudioLayer() {
        return this.audioLayer;
    }

    public String getCasterId() {
        return this.casterId;
    }

    public Integer getFollowEnable() {
        return this.followEnable;
    }

    public List<String> getMixList() {
        return this.mixList;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getSceneId() {
        return this.sceneId;
    }

    public static class AudioLayer
    extends TeaModel {
        @NameInMap(value="Filter")
        private String filter;
        @NameInMap(value="FixedDelayDuration")
        private Integer fixedDelayDuration;
        @NameInMap(value="ValidChannel")
        private String validChannel;
        @NameInMap(value="VolumeRate")
        private Float volumeRate;

        private AudioLayer(Builder builder) {
            this.filter = builder.filter;
            this.fixedDelayDuration = builder.fixedDelayDuration;
            this.validChannel = builder.validChannel;
            this.volumeRate = builder.volumeRate;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static AudioLayer create() {
            return AudioLayer.builder().build();
        }

        public String getFilter() {
            return this.filter;
        }

        public Integer getFixedDelayDuration() {
            return this.fixedDelayDuration;
        }

        public String getValidChannel() {
            return this.validChannel;
        }

        public Float getVolumeRate() {
            return this.volumeRate;
        }

        public static final class Builder {
            private String filter;
            private Integer fixedDelayDuration;
            private String validChannel;
            private Float volumeRate;

            private Builder() {
            }

            private Builder(AudioLayer model) {
                this.filter = model.filter;
                this.fixedDelayDuration = model.fixedDelayDuration;
                this.validChannel = model.validChannel;
                this.volumeRate = model.volumeRate;
            }

            public Builder filter(String filter) {
                this.filter = filter;
                return this;
            }

            public Builder fixedDelayDuration(Integer fixedDelayDuration) {
                this.fixedDelayDuration = fixedDelayDuration;
                return this;
            }

            public Builder validChannel(String validChannel) {
                this.validChannel = validChannel;
                return this;
            }

            public Builder volumeRate(Float volumeRate) {
                this.volumeRate = volumeRate;
                return this;
            }

            public AudioLayer build() {
                return new AudioLayer(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateCasterSceneAudioRequest, Builder> {
        private List<AudioLayer> audioLayer;
        private String casterId;
        private Integer followEnable;
        private List<String> mixList;
        private Long ownerId;
        private String regionId;
        private String sceneId;

        private Builder() {
        }

        private Builder(UpdateCasterSceneAudioRequest request) {
            super((Request)request);
            this.audioLayer = request.audioLayer;
            this.casterId = request.casterId;
            this.followEnable = request.followEnable;
            this.mixList = request.mixList;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.sceneId = request.sceneId;
        }

        public Builder audioLayer(List<AudioLayer> audioLayer) {
            this.putQueryParameter("AudioLayer", audioLayer);
            this.audioLayer = audioLayer;
            return this;
        }

        public Builder casterId(String casterId) {
            this.putQueryParameter("CasterId", casterId);
            this.casterId = casterId;
            return this;
        }

        public Builder followEnable(Integer followEnable) {
            this.putQueryParameter("FollowEnable", followEnable);
            this.followEnable = followEnable;
            return this;
        }

        public Builder mixList(List<String> mixList) {
            this.putQueryParameter("MixList", mixList);
            this.mixList = mixList;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder sceneId(String sceneId) {
            this.putQueryParameter("SceneId", sceneId);
            this.sceneId = sceneId;
            return this;
        }

        public UpdateCasterSceneAudioRequest build() {
            return new UpdateCasterSceneAudioRequest(this);
        }
    }
}

