/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class UpdateEventSubRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="CallbackUrl")
    @Validation(required=true)
    private String callbackUrl;
    @Query
    @NameInMap(value="ChannelId")
    private String channelId;
    @Query
    @NameInMap(value="Events")
    @Validation(required=true)
    private List<String> events;
    @Query
    @NameInMap(value="SubscribeId")
    @Validation(required=true)
    private String subscribeId;
    @Query
    @NameInMap(value="Users")
    private List<String> users;

    private UpdateEventSubRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.callbackUrl = builder.callbackUrl;
        this.channelId = builder.channelId;
        this.events = builder.events;
        this.subscribeId = builder.subscribeId;
        this.users = builder.users;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateEventSubRequest create() {
        return UpdateEventSubRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public String getSubscribeId() {
        return this.subscribeId;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public static final class Builder
    extends Request.Builder<UpdateEventSubRequest, Builder> {
        private String appId;
        private String callbackUrl;
        private String channelId;
        private List<String> events;
        private String subscribeId;
        private List<String> users;

        private Builder() {
        }

        private Builder(UpdateEventSubRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.callbackUrl = request.callbackUrl;
            this.channelId = request.channelId;
            this.events = request.events;
            this.subscribeId = request.subscribeId;
            this.users = request.users;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder callbackUrl(String callbackUrl) {
            this.putQueryParameter("CallbackUrl", callbackUrl);
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder channelId(String channelId) {
            this.putQueryParameter("ChannelId", channelId);
            this.channelId = channelId;
            return this;
        }

        public Builder events(List<String> events) {
            this.putQueryParameter("Events", events);
            this.events = events;
            return this;
        }

        public Builder subscribeId(String subscribeId) {
            this.putQueryParameter("SubscribeId", subscribeId);
            this.subscribeId = subscribeId;
            return this;
        }

        public Builder users(List<String> users) {
            this.putQueryParameter("Users", users);
            this.users = users;
            return this;
        }

        public UpdateEventSubRequest build() {
            return new UpdateEventSubRequest(this);
        }
    }
}

