/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateLiveMPUTaskRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="ChannelId")
    @Validation(required=true)
    private String channelId;
    @Query
    @NameInMap(value="MixMode")
    private String mixMode;
    @Query
    @NameInMap(value="MultiStreamURL")
    private List<MultiStreamURL> multiStreamURL;
    @Query
    @NameInMap(value="SeiParams")
    private SeiParams seiParams;
    @Query
    @NameInMap(value="SingleSubParams")
    private SingleSubParams singleSubParams;
    @Query
    @NameInMap(value="StreamURL")
    private String streamURL;
    @Query
    @NameInMap(value="TaskId")
    @Validation(required=true)
    private String taskId;
    @Query
    @NameInMap(value="TranscodeParams")
    private TranscodeParams transcodeParams;

    private UpdateLiveMPUTaskRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.channelId = builder.channelId;
        this.mixMode = builder.mixMode;
        this.multiStreamURL = builder.multiStreamURL;
        this.seiParams = builder.seiParams;
        this.singleSubParams = builder.singleSubParams;
        this.streamURL = builder.streamURL;
        this.taskId = builder.taskId;
        this.transcodeParams = builder.transcodeParams;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateLiveMPUTaskRequest create() {
        return UpdateLiveMPUTaskRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getMixMode() {
        return this.mixMode;
    }

    public List<MultiStreamURL> getMultiStreamURL() {
        return this.multiStreamURL;
    }

    public SeiParams getSeiParams() {
        return this.seiParams;
    }

    public SingleSubParams getSingleSubParams() {
        return this.singleSubParams;
    }

    public String getStreamURL() {
        return this.streamURL;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public TranscodeParams getTranscodeParams() {
        return this.transcodeParams;
    }

    public static class TranscodeParams
    extends TeaModel {
        @NameInMap(value="Background")
        private Background background;
        @NameInMap(value="EncodeParams")
        private EncodeParams encodeParams;
        @NameInMap(value="Layout")
        private Layout layout;
        @NameInMap(value="UserInfos")
        private List<UserInfos> userInfos;

        private TranscodeParams(Builder builder) {
            this.background = builder.background;
            this.encodeParams = builder.encodeParams;
            this.layout = builder.layout;
            this.userInfos = builder.userInfos;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static TranscodeParams create() {
            return TranscodeParams.builder().build();
        }

        public Background getBackground() {
            return this.background;
        }

        public EncodeParams getEncodeParams() {
            return this.encodeParams;
        }

        public Layout getLayout() {
            return this.layout;
        }

        public List<UserInfos> getUserInfos() {
            return this.userInfos;
        }

        public static final class Builder {
            private Background background;
            private EncodeParams encodeParams;
            private Layout layout;
            private List<UserInfos> userInfos;

            private Builder() {
            }

            private Builder(TranscodeParams model) {
                this.background = model.background;
                this.encodeParams = model.encodeParams;
                this.layout = model.layout;
                this.userInfos = model.userInfos;
            }

            public Builder background(Background background) {
                this.background = background;
                return this;
            }

            public Builder encodeParams(EncodeParams encodeParams) {
                this.encodeParams = encodeParams;
                return this;
            }

            public Builder layout(Layout layout) {
                this.layout = layout;
                return this;
            }

            public Builder userInfos(List<UserInfos> userInfos) {
                this.userInfos = userInfos;
                return this;
            }

            public TranscodeParams build() {
                return new TranscodeParams(this);
            }
        }
    }

    public static class UserInfos
    extends TeaModel {
        @NameInMap(value="ChannelId")
        private String channelId;
        @NameInMap(value="SourceType")
        private String sourceType;
        @NameInMap(value="StreamType")
        private String streamType;
        @NameInMap(value="UserId")
        @Validation(required=true)
        private String userId;

        private UserInfos(Builder builder) {
            this.channelId = builder.channelId;
            this.sourceType = builder.sourceType;
            this.streamType = builder.streamType;
            this.userId = builder.userId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static UserInfos create() {
            return UserInfos.builder().build();
        }

        public String getChannelId() {
            return this.channelId;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getStreamType() {
            return this.streamType;
        }

        public String getUserId() {
            return this.userId;
        }

        public static final class Builder {
            private String channelId;
            private String sourceType;
            private String streamType;
            private String userId;

            private Builder() {
            }

            private Builder(UserInfos model) {
                this.channelId = model.channelId;
                this.sourceType = model.sourceType;
                this.streamType = model.streamType;
                this.userId = model.userId;
            }

            public Builder channelId(String channelId) {
                this.channelId = channelId;
                return this;
            }

            public Builder sourceType(String sourceType) {
                this.sourceType = sourceType;
                return this;
            }

            public Builder streamType(String streamType) {
                this.streamType = streamType;
                return this;
            }

            public Builder userId(String userId) {
                this.userId = userId;
                return this;
            }

            public UserInfos build() {
                return new UserInfos(this);
            }
        }
    }

    public static class Layout
    extends TeaModel {
        @NameInMap(value="UserPanes")
        private List<UserPanes> userPanes;

        private Layout(Builder builder) {
            this.userPanes = builder.userPanes;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Layout create() {
            return Layout.builder().build();
        }

        public List<UserPanes> getUserPanes() {
            return this.userPanes;
        }

        public static final class Builder {
            private List<UserPanes> userPanes;

            private Builder() {
            }

            private Builder(Layout model) {
                this.userPanes = model.userPanes;
            }

            public Builder userPanes(List<UserPanes> userPanes) {
                this.userPanes = userPanes;
                return this;
            }

            public Layout build() {
                return new Layout(this);
            }
        }
    }

    public static class UserPanes
    extends TeaModel {
        @NameInMap(value="BackgroundImageUrl")
        private String backgroundImageUrl;
        @NameInMap(value="Height")
        private String height;
        @NameInMap(value="RenderMode")
        private String renderMode;
        @NameInMap(value="UserInfo")
        private UserInfo userInfo;
        @NameInMap(value="Width")
        private String width;
        @NameInMap(value="X")
        private String x;
        @NameInMap(value="Y")
        private String y;
        @NameInMap(value="ZOrder")
        private String zOrder;

        private UserPanes(Builder builder) {
            this.backgroundImageUrl = builder.backgroundImageUrl;
            this.height = builder.height;
            this.renderMode = builder.renderMode;
            this.userInfo = builder.userInfo;
            this.width = builder.width;
            this.x = builder.x;
            this.y = builder.y;
            this.zOrder = builder.zOrder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static UserPanes create() {
            return UserPanes.builder().build();
        }

        public String getBackgroundImageUrl() {
            return this.backgroundImageUrl;
        }

        public String getHeight() {
            return this.height;
        }

        public String getRenderMode() {
            return this.renderMode;
        }

        public UserInfo getUserInfo() {
            return this.userInfo;
        }

        public String getWidth() {
            return this.width;
        }

        public String getX() {
            return this.x;
        }

        public String getY() {
            return this.y;
        }

        public String getZOrder() {
            return this.zOrder;
        }

        public static final class Builder {
            private String backgroundImageUrl;
            private String height;
            private String renderMode;
            private UserInfo userInfo;
            private String width;
            private String x;
            private String y;
            private String zOrder;

            private Builder() {
            }

            private Builder(UserPanes model) {
                this.backgroundImageUrl = model.backgroundImageUrl;
                this.height = model.height;
                this.renderMode = model.renderMode;
                this.userInfo = model.userInfo;
                this.width = model.width;
                this.x = model.x;
                this.y = model.y;
                this.zOrder = model.zOrder;
            }

            public Builder backgroundImageUrl(String backgroundImageUrl) {
                this.backgroundImageUrl = backgroundImageUrl;
                return this;
            }

            public Builder height(String height) {
                this.height = height;
                return this;
            }

            public Builder renderMode(String renderMode) {
                this.renderMode = renderMode;
                return this;
            }

            public Builder userInfo(UserInfo userInfo) {
                this.userInfo = userInfo;
                return this;
            }

            public Builder width(String width) {
                this.width = width;
                return this;
            }

            public Builder x(String x) {
                this.x = x;
                return this;
            }

            public Builder y(String y) {
                this.y = y;
                return this;
            }

            public Builder zOrder(String zOrder) {
                this.zOrder = zOrder;
                return this;
            }

            public UserPanes build() {
                return new UserPanes(this);
            }
        }
    }

    public static class UserInfo
    extends TeaModel {
        @NameInMap(value="ChannelId")
        private String channelId;
        @NameInMap(value="SourceType")
        private String sourceType;
        @NameInMap(value="UserId")
        private String userId;

        private UserInfo(Builder builder) {
            this.channelId = builder.channelId;
            this.sourceType = builder.sourceType;
            this.userId = builder.userId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static UserInfo create() {
            return UserInfo.builder().build();
        }

        public String getChannelId() {
            return this.channelId;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getUserId() {
            return this.userId;
        }

        public static final class Builder {
            private String channelId;
            private String sourceType;
            private String userId;

            private Builder() {
            }

            private Builder(UserInfo model) {
                this.channelId = model.channelId;
                this.sourceType = model.sourceType;
                this.userId = model.userId;
            }

            public Builder channelId(String channelId) {
                this.channelId = channelId;
                return this;
            }

            public Builder sourceType(String sourceType) {
                this.sourceType = sourceType;
                return this;
            }

            public Builder userId(String userId) {
                this.userId = userId;
                return this;
            }

            public UserInfo build() {
                return new UserInfo(this);
            }
        }
    }

    public static class EncodeParams
    extends TeaModel {
        @NameInMap(value="AudioBitrate")
        private String audioBitrate;
        @NameInMap(value="AudioChannels")
        private String audioChannels;
        @NameInMap(value="AudioOnly")
        private String audioOnly;
        @NameInMap(value="AudioSampleRate")
        private String audioSampleRate;
        @NameInMap(value="EnhancedParam")
        private String enhancedParam;
        @NameInMap(value="VideoBitrate")
        private String videoBitrate;
        @NameInMap(value="VideoCodec")
        private String videoCodec;
        @NameInMap(value="VideoFramerate")
        private String videoFramerate;
        @NameInMap(value="VideoGop")
        private String videoGop;
        @NameInMap(value="VideoHeight")
        private String videoHeight;
        @NameInMap(value="VideoWidth")
        private String videoWidth;

        private EncodeParams(Builder builder) {
            this.audioBitrate = builder.audioBitrate;
            this.audioChannels = builder.audioChannels;
            this.audioOnly = builder.audioOnly;
            this.audioSampleRate = builder.audioSampleRate;
            this.enhancedParam = builder.enhancedParam;
            this.videoBitrate = builder.videoBitrate;
            this.videoCodec = builder.videoCodec;
            this.videoFramerate = builder.videoFramerate;
            this.videoGop = builder.videoGop;
            this.videoHeight = builder.videoHeight;
            this.videoWidth = builder.videoWidth;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static EncodeParams create() {
            return EncodeParams.builder().build();
        }

        public String getAudioBitrate() {
            return this.audioBitrate;
        }

        public String getAudioChannels() {
            return this.audioChannels;
        }

        public String getAudioOnly() {
            return this.audioOnly;
        }

        public String getAudioSampleRate() {
            return this.audioSampleRate;
        }

        public String getEnhancedParam() {
            return this.enhancedParam;
        }

        public String getVideoBitrate() {
            return this.videoBitrate;
        }

        public String getVideoCodec() {
            return this.videoCodec;
        }

        public String getVideoFramerate() {
            return this.videoFramerate;
        }

        public String getVideoGop() {
            return this.videoGop;
        }

        public String getVideoHeight() {
            return this.videoHeight;
        }

        public String getVideoWidth() {
            return this.videoWidth;
        }

        public static final class Builder {
            private String audioBitrate;
            private String audioChannels;
            private String audioOnly;
            private String audioSampleRate;
            private String enhancedParam;
            private String videoBitrate;
            private String videoCodec;
            private String videoFramerate;
            private String videoGop;
            private String videoHeight;
            private String videoWidth;

            private Builder() {
            }

            private Builder(EncodeParams model) {
                this.audioBitrate = model.audioBitrate;
                this.audioChannels = model.audioChannels;
                this.audioOnly = model.audioOnly;
                this.audioSampleRate = model.audioSampleRate;
                this.enhancedParam = model.enhancedParam;
                this.videoBitrate = model.videoBitrate;
                this.videoCodec = model.videoCodec;
                this.videoFramerate = model.videoFramerate;
                this.videoGop = model.videoGop;
                this.videoHeight = model.videoHeight;
                this.videoWidth = model.videoWidth;
            }

            public Builder audioBitrate(String audioBitrate) {
                this.audioBitrate = audioBitrate;
                return this;
            }

            public Builder audioChannels(String audioChannels) {
                this.audioChannels = audioChannels;
                return this;
            }

            public Builder audioOnly(String audioOnly) {
                this.audioOnly = audioOnly;
                return this;
            }

            public Builder audioSampleRate(String audioSampleRate) {
                this.audioSampleRate = audioSampleRate;
                return this;
            }

            public Builder enhancedParam(String enhancedParam) {
                this.enhancedParam = enhancedParam;
                return this;
            }

            public Builder videoBitrate(String videoBitrate) {
                this.videoBitrate = videoBitrate;
                return this;
            }

            public Builder videoCodec(String videoCodec) {
                this.videoCodec = videoCodec;
                return this;
            }

            public Builder videoFramerate(String videoFramerate) {
                this.videoFramerate = videoFramerate;
                return this;
            }

            public Builder videoGop(String videoGop) {
                this.videoGop = videoGop;
                return this;
            }

            public Builder videoHeight(String videoHeight) {
                this.videoHeight = videoHeight;
                return this;
            }

            public Builder videoWidth(String videoWidth) {
                this.videoWidth = videoWidth;
                return this;
            }

            public EncodeParams build() {
                return new EncodeParams(this);
            }
        }
    }

    public static class Background
    extends TeaModel {
        @NameInMap(value="RenderMode")
        private String renderMode;
        @NameInMap(value="URL")
        private String URL;

        private Background(Builder builder) {
            this.renderMode = builder.renderMode;
            this.URL = builder.URL;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Background create() {
            return Background.builder().build();
        }

        public String getRenderMode() {
            return this.renderMode;
        }

        public String getURL() {
            return this.URL;
        }

        public static final class Builder {
            private String renderMode;
            private String URL;

            private Builder() {
            }

            private Builder(Background model) {
                this.renderMode = model.renderMode;
                this.URL = model.URL;
            }

            public Builder renderMode(String renderMode) {
                this.renderMode = renderMode;
                return this;
            }

            public Builder URL(String URL) {
                this.URL = URL;
                return this;
            }

            public Background build() {
                return new Background(this);
            }
        }
    }

    public static class SingleSubParams
    extends TeaModel {
        @NameInMap(value="SourceType")
        private String sourceType;
        @NameInMap(value="StreamType")
        private String streamType;
        @NameInMap(value="UserId")
        @Validation(required=true)
        private String userId;

        private SingleSubParams(Builder builder) {
            this.sourceType = builder.sourceType;
            this.streamType = builder.streamType;
            this.userId = builder.userId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static SingleSubParams create() {
            return SingleSubParams.builder().build();
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getStreamType() {
            return this.streamType;
        }

        public String getUserId() {
            return this.userId;
        }

        public static final class Builder {
            private String sourceType;
            private String streamType;
            private String userId;

            private Builder() {
            }

            private Builder(SingleSubParams model) {
                this.sourceType = model.sourceType;
                this.streamType = model.streamType;
                this.userId = model.userId;
            }

            public Builder sourceType(String sourceType) {
                this.sourceType = sourceType;
                return this;
            }

            public Builder streamType(String streamType) {
                this.streamType = streamType;
                return this;
            }

            public Builder userId(String userId) {
                this.userId = userId;
                return this;
            }

            public SingleSubParams build() {
                return new SingleSubParams(this);
            }
        }
    }

    public static class SeiParams
    extends TeaModel {
        @NameInMap(value="LayoutVolume")
        private LayoutVolume layoutVolume;
        @NameInMap(value="PassThrough")
        private PassThrough passThrough;

        private SeiParams(Builder builder) {
            this.layoutVolume = builder.layoutVolume;
            this.passThrough = builder.passThrough;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static SeiParams create() {
            return SeiParams.builder().build();
        }

        public LayoutVolume getLayoutVolume() {
            return this.layoutVolume;
        }

        public PassThrough getPassThrough() {
            return this.passThrough;
        }

        public static final class Builder {
            private LayoutVolume layoutVolume;
            private PassThrough passThrough;

            private Builder() {
            }

            private Builder(SeiParams model) {
                this.layoutVolume = model.layoutVolume;
                this.passThrough = model.passThrough;
            }

            public Builder layoutVolume(LayoutVolume layoutVolume) {
                this.layoutVolume = layoutVolume;
                return this;
            }

            public Builder passThrough(PassThrough passThrough) {
                this.passThrough = passThrough;
                return this;
            }

            public SeiParams build() {
                return new SeiParams(this);
            }
        }
    }

    public static class PassThrough
    extends TeaModel {
        @NameInMap(value="FollowIdr")
        private String followIdr;
        @NameInMap(value="Interval")
        private String interval;
        @NameInMap(value="PayloadContent")
        private String payloadContent;
        @NameInMap(value="PayloadContentKey")
        private String payloadContentKey;

        private PassThrough(Builder builder) {
            this.followIdr = builder.followIdr;
            this.interval = builder.interval;
            this.payloadContent = builder.payloadContent;
            this.payloadContentKey = builder.payloadContentKey;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static PassThrough create() {
            return PassThrough.builder().build();
        }

        public String getFollowIdr() {
            return this.followIdr;
        }

        public String getInterval() {
            return this.interval;
        }

        public String getPayloadContent() {
            return this.payloadContent;
        }

        public String getPayloadContentKey() {
            return this.payloadContentKey;
        }

        public static final class Builder {
            private String followIdr;
            private String interval;
            private String payloadContent;
            private String payloadContentKey;

            private Builder() {
            }

            private Builder(PassThrough model) {
                this.followIdr = model.followIdr;
                this.interval = model.interval;
                this.payloadContent = model.payloadContent;
                this.payloadContentKey = model.payloadContentKey;
            }

            public Builder followIdr(String followIdr) {
                this.followIdr = followIdr;
                return this;
            }

            public Builder interval(String interval) {
                this.interval = interval;
                return this;
            }

            public Builder payloadContent(String payloadContent) {
                this.payloadContent = payloadContent;
                return this;
            }

            public Builder payloadContentKey(String payloadContentKey) {
                this.payloadContentKey = payloadContentKey;
                return this;
            }

            public PassThrough build() {
                return new PassThrough(this);
            }
        }
    }

    public static class LayoutVolume
    extends TeaModel {
        @NameInMap(value="FollowIdr")
        private String followIdr;
        @NameInMap(value="Interval")
        private String interval;

        private LayoutVolume(Builder builder) {
            this.followIdr = builder.followIdr;
            this.interval = builder.interval;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static LayoutVolume create() {
            return LayoutVolume.builder().build();
        }

        public String getFollowIdr() {
            return this.followIdr;
        }

        public String getInterval() {
            return this.interval;
        }

        public static final class Builder {
            private String followIdr;
            private String interval;

            private Builder() {
            }

            private Builder(LayoutVolume model) {
                this.followIdr = model.followIdr;
                this.interval = model.interval;
            }

            public Builder followIdr(String followIdr) {
                this.followIdr = followIdr;
                return this;
            }

            public Builder interval(String interval) {
                this.interval = interval;
                return this;
            }

            public LayoutVolume build() {
                return new LayoutVolume(this);
            }
        }
    }

    public static class MultiStreamURL
    extends TeaModel {
        @NameInMap(value="IsAliCdn")
        private Boolean isAliCdn;
        @NameInMap(value="URL")
        private String URL;

        private MultiStreamURL(Builder builder) {
            this.isAliCdn = builder.isAliCdn;
            this.URL = builder.URL;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static MultiStreamURL create() {
            return MultiStreamURL.builder().build();
        }

        public Boolean getIsAliCdn() {
            return this.isAliCdn;
        }

        public String getURL() {
            return this.URL;
        }

        public static final class Builder {
            private Boolean isAliCdn;
            private String URL;

            private Builder() {
            }

            private Builder(MultiStreamURL model) {
                this.isAliCdn = model.isAliCdn;
                this.URL = model.URL;
            }

            public Builder isAliCdn(Boolean isAliCdn) {
                this.isAliCdn = isAliCdn;
                return this;
            }

            public Builder URL(String URL) {
                this.URL = URL;
                return this;
            }

            public MultiStreamURL build() {
                return new MultiStreamURL(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateLiveMPUTaskRequest, Builder> {
        private String appId;
        private String channelId;
        private String mixMode;
        private List<MultiStreamURL> multiStreamURL;
        private SeiParams seiParams;
        private SingleSubParams singleSubParams;
        private String streamURL;
        private String taskId;
        private TranscodeParams transcodeParams;

        private Builder() {
        }

        private Builder(UpdateLiveMPUTaskRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.channelId = request.channelId;
            this.mixMode = request.mixMode;
            this.multiStreamURL = request.multiStreamURL;
            this.seiParams = request.seiParams;
            this.singleSubParams = request.singleSubParams;
            this.streamURL = request.streamURL;
            this.taskId = request.taskId;
            this.transcodeParams = request.transcodeParams;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder channelId(String channelId) {
            this.putQueryParameter("ChannelId", channelId);
            this.channelId = channelId;
            return this;
        }

        public Builder mixMode(String mixMode) {
            this.putQueryParameter("MixMode", mixMode);
            this.mixMode = mixMode;
            return this;
        }

        public Builder multiStreamURL(List<MultiStreamURL> multiStreamURL) {
            String multiStreamURLShrink = this.shrink(multiStreamURL, "MultiStreamURL", "json");
            this.putQueryParameter("MultiStreamURL", multiStreamURLShrink);
            this.multiStreamURL = multiStreamURL;
            return this;
        }

        public Builder seiParams(SeiParams seiParams) {
            String seiParamsShrink = this.shrink((Object)seiParams, "SeiParams", "json");
            this.putQueryParameter("SeiParams", seiParamsShrink);
            this.seiParams = seiParams;
            return this;
        }

        public Builder singleSubParams(SingleSubParams singleSubParams) {
            String singleSubParamsShrink = this.shrink((Object)singleSubParams, "SingleSubParams", "json");
            this.putQueryParameter("SingleSubParams", singleSubParamsShrink);
            this.singleSubParams = singleSubParams;
            return this;
        }

        public Builder streamURL(String streamURL) {
            this.putQueryParameter("StreamURL", streamURL);
            this.streamURL = streamURL;
            return this;
        }

        public Builder taskId(String taskId) {
            this.putQueryParameter("TaskId", taskId);
            this.taskId = taskId;
            return this;
        }

        public Builder transcodeParams(TranscodeParams transcodeParams) {
            String transcodeParamsShrink = this.shrink((Object)transcodeParams, "TranscodeParams", "json");
            this.putQueryParameter("TranscodeParams", transcodeParamsShrink);
            this.transcodeParams = transcodeParams;
            return this;
        }

        public UpdateLiveMPUTaskRequest build() {
            return new UpdateLiveMPUTaskRequest(this);
        }
    }
}

