/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdateLivePackageConfigRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    @Validation(required=true)
    private String appName;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="IgnoreTranscode")
    private Boolean ignoreTranscode;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PartDuration")
    private Integer partDuration;
    @Query
    @NameInMap(value="Protocol")
    @Validation(required=true)
    private String protocol;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="SegmentDuration")
    @Validation(required=true)
    private Integer segmentDuration;
    @Query
    @NameInMap(value="SegmentNum")
    @Validation(required=true)
    private Integer segmentNum;
    @Query
    @NameInMap(value="StreamName")
    @Validation(required=true)
    private String streamName;

    private UpdateLivePackageConfigRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.domainName = builder.domainName;
        this.ignoreTranscode = builder.ignoreTranscode;
        this.ownerId = builder.ownerId;
        this.partDuration = builder.partDuration;
        this.protocol = builder.protocol;
        this.regionId = builder.regionId;
        this.segmentDuration = builder.segmentDuration;
        this.segmentNum = builder.segmentNum;
        this.streamName = builder.streamName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateLivePackageConfigRequest create() {
        return UpdateLivePackageConfigRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Boolean getIgnoreTranscode() {
        return this.ignoreTranscode;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Integer getPartDuration() {
        return this.partDuration;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public Integer getSegmentDuration() {
        return this.segmentDuration;
    }

    public Integer getSegmentNum() {
        return this.segmentNum;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public static final class Builder
    extends Request.Builder<UpdateLivePackageConfigRequest, Builder> {
        private String appName;
        private String domainName;
        private Boolean ignoreTranscode;
        private Long ownerId;
        private Integer partDuration;
        private String protocol;
        private String regionId;
        private Integer segmentDuration;
        private Integer segmentNum;
        private String streamName;

        private Builder() {
        }

        private Builder(UpdateLivePackageConfigRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.domainName = request.domainName;
            this.ignoreTranscode = request.ignoreTranscode;
            this.ownerId = request.ownerId;
            this.partDuration = request.partDuration;
            this.protocol = request.protocol;
            this.regionId = request.regionId;
            this.segmentDuration = request.segmentDuration;
            this.segmentNum = request.segmentNum;
            this.streamName = request.streamName;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder ignoreTranscode(Boolean ignoreTranscode) {
            this.putQueryParameter("IgnoreTranscode", ignoreTranscode);
            this.ignoreTranscode = ignoreTranscode;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder partDuration(Integer partDuration) {
            this.putQueryParameter("PartDuration", partDuration);
            this.partDuration = partDuration;
            return this;
        }

        public Builder protocol(String protocol) {
            this.putQueryParameter("Protocol", protocol);
            this.protocol = protocol;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder segmentDuration(Integer segmentDuration) {
            this.putQueryParameter("SegmentDuration", segmentDuration);
            this.segmentDuration = segmentDuration;
            return this;
        }

        public Builder segmentNum(Integer segmentNum) {
            this.putQueryParameter("SegmentNum", segmentNum);
            this.segmentNum = segmentNum;
            return this;
        }

        public Builder streamName(String streamName) {
            this.putQueryParameter("StreamName", streamName);
            this.streamName = streamName;
            return this;
        }

        public UpdateLivePackageConfigRequest build() {
            return new UpdateLivePackageConfigRequest(this);
        }
    }
}

