/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class UpdateMessageAppRequest
extends Request {
    @Body
    @NameInMap(value="AppConfig")
    private Map<String, String> appConfig;
    @Body
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Body
    @NameInMap(value="AppName")
    private String appName;
    @Body
    @NameInMap(value="Extension")
    private Map<String, String> extension;

    private UpdateMessageAppRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appConfig = builder.appConfig;
        this.appId = builder.appId;
        this.appName = builder.appName;
        this.extension = builder.extension;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateMessageAppRequest create() {
        return UpdateMessageAppRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Map<String, String> getAppConfig() {
        return this.appConfig;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public Map<String, String> getExtension() {
        return this.extension;
    }

    public static final class Builder
    extends Request.Builder<UpdateMessageAppRequest, Builder> {
        private Map<String, String> appConfig;
        private String appId;
        private String appName;
        private Map<String, String> extension;

        private Builder() {
        }

        private Builder(UpdateMessageAppRequest request) {
            super((Request)request);
            this.appConfig = request.appConfig;
            this.appId = request.appId;
            this.appName = request.appName;
            this.extension = request.extension;
        }

        public Builder appConfig(Map<String, String> appConfig) {
            String appConfigShrink = this.shrink(appConfig, "AppConfig", "json");
            this.putBodyParameter("AppConfig", appConfigShrink);
            this.appConfig = appConfig;
            return this;
        }

        public Builder appId(String appId) {
            this.putBodyParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder appName(String appName) {
            this.putBodyParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder extension(Map<String, String> extension) {
            String extensionShrink = this.shrink(extension, "Extension", "json");
            this.putBodyParameter("Extension", extensionShrink);
            this.extension = extension;
            return this;
        }

        public UpdateMessageAppRequest build() {
            return new UpdateMessageAppRequest(this);
        }
    }
}

