/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class UpdateMessageGroupRequest
extends Request {
    @Body
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Body
    @NameInMap(value="Extension")
    private Map<String, String> extension;
    @Body
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;

    private UpdateMessageGroupRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.extension = builder.extension;
        this.groupId = builder.groupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateMessageGroupRequest create() {
        return UpdateMessageGroupRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public Map<String, String> getExtension() {
        return this.extension;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public static final class Builder
    extends Request.Builder<UpdateMessageGroupRequest, Builder> {
        private String appId;
        private Map<String, String> extension;
        private String groupId;

        private Builder() {
        }

        private Builder(UpdateMessageGroupRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.extension = request.extension;
            this.groupId = request.groupId;
        }

        public Builder appId(String appId) {
            this.putBodyParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder extension(Map<String, String> extension) {
            String extensionShrink = this.shrink(extension, "Extension", "json");
            this.putBodyParameter("Extension", extensionShrink);
            this.extension = extension;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putBodyParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public UpdateMessageGroupRequest build() {
            return new UpdateMessageGroupRequest(this);
        }
    }
}

