/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdateMixStreamRequest
extends Request {
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="InputStreamList")
    @Validation(required=true)
    private String inputStreamList;
    @Query
    @NameInMap(value="LayoutId")
    private String layoutId;
    @Query
    @NameInMap(value="MixStreamId")
    @Validation(required=true)
    private String mixStreamId;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;

    private UpdateMixStreamRequest(Builder builder) {
        super((Request.Builder)builder);
        this.domainName = builder.domainName;
        this.inputStreamList = builder.inputStreamList;
        this.layoutId = builder.layoutId;
        this.mixStreamId = builder.mixStreamId;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateMixStreamRequest create() {
        return UpdateMixStreamRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getInputStreamList() {
        return this.inputStreamList;
    }

    public String getLayoutId() {
        return this.layoutId;
    }

    public String getMixStreamId() {
        return this.mixStreamId;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public static final class Builder
    extends Request.Builder<UpdateMixStreamRequest, Builder> {
        private String domainName;
        private String inputStreamList;
        private String layoutId;
        private String mixStreamId;
        private Long ownerId;
        private String regionId;

        private Builder() {
        }

        private Builder(UpdateMixStreamRequest request) {
            super((Request)request);
            this.domainName = request.domainName;
            this.inputStreamList = request.inputStreamList;
            this.layoutId = request.layoutId;
            this.mixStreamId = request.mixStreamId;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder inputStreamList(String inputStreamList) {
            this.putQueryParameter("InputStreamList", inputStreamList);
            this.inputStreamList = inputStreamList;
            return this;
        }

        public Builder layoutId(String layoutId) {
            this.putQueryParameter("LayoutId", layoutId);
            this.layoutId = layoutId;
            return this;
        }

        public Builder mixStreamId(String mixStreamId) {
            this.putQueryParameter("MixStreamId", mixStreamId);
            this.mixStreamId = mixStreamId;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public UpdateMixStreamRequest build() {
            return new UpdateMixStreamRequest(this);
        }
    }
}

