/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.mts20140618.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ImAuditRequest
extends Request {
    @Query
    @NameInMap(value="BizType")
    private String bizType;
    @Query
    @NameInMap(value="Contents")
    private String contents;
    @Query
    @NameInMap(value="Images")
    private String images;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;
    @Query
    @NameInMap(value="Scenes")
    @Validation(required=true)
    private String scenes;

    private ImAuditRequest(Builder builder) {
        super((Request.Builder)builder);
        this.bizType = builder.bizType;
        this.contents = builder.contents;
        this.images = builder.images;
        this.ownerId = builder.ownerId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.scenes = builder.scenes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ImAuditRequest create() {
        return ImAuditRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getBizType() {
        return this.bizType;
    }

    public String getContents() {
        return this.contents;
    }

    public String getImages() {
        return this.images;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public String getScenes() {
        return this.scenes;
    }

    public static final class Builder
    extends Request.Builder<ImAuditRequest, Builder> {
        private String bizType;
        private String contents;
        private String images;
        private Long ownerId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;
        private String scenes;

        private Builder() {
        }

        private Builder(ImAuditRequest request) {
            super((Request)request);
            this.bizType = request.bizType;
            this.contents = request.contents;
            this.images = request.images;
            this.ownerId = request.ownerId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
            this.scenes = request.scenes;
        }

        public Builder bizType(String bizType) {
            this.putQueryParameter("BizType", bizType);
            this.bizType = bizType;
            return this;
        }

        public Builder contents(String contents) {
            this.putQueryParameter("Contents", contents);
            this.contents = contents;
            return this;
        }

        public Builder images(String images) {
            this.putQueryParameter("Images", images);
            this.images = images;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public Builder scenes(String scenes) {
            this.putQueryParameter("Scenes", scenes);
            this.scenes = scenes;
            return this;
        }

        public ImAuditRequest build() {
            return new ImAuditRequest(this);
        }
    }
}

