/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.mts20140618.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListMediaWorkflowExecutionsRequest
extends Request {
    @Query
    @NameInMap(value="InputFileURL")
    private String inputFileURL;
    @Query
    @NameInMap(value="MaximumPageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Long maximumPageSize;
    @Query
    @NameInMap(value="MediaWorkflowId")
    private String mediaWorkflowId;
    @Query
    @NameInMap(value="MediaWorkflowName")
    private String mediaWorkflowName;
    @Query
    @NameInMap(value="NextPageToken")
    private String nextPageToken;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;

    private ListMediaWorkflowExecutionsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.inputFileURL = builder.inputFileURL;
        this.maximumPageSize = builder.maximumPageSize;
        this.mediaWorkflowId = builder.mediaWorkflowId;
        this.mediaWorkflowName = builder.mediaWorkflowName;
        this.nextPageToken = builder.nextPageToken;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListMediaWorkflowExecutionsRequest create() {
        return ListMediaWorkflowExecutionsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getInputFileURL() {
        return this.inputFileURL;
    }

    public Long getMaximumPageSize() {
        return this.maximumPageSize;
    }

    public String getMediaWorkflowId() {
        return this.mediaWorkflowId;
    }

    public String getMediaWorkflowName() {
        return this.mediaWorkflowName;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public static final class Builder
    extends Request.Builder<ListMediaWorkflowExecutionsRequest, Builder> {
        private String inputFileURL;
        private Long maximumPageSize;
        private String mediaWorkflowId;
        private String mediaWorkflowName;
        private String nextPageToken;
        private String ownerAccount;
        private Long ownerId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;

        private Builder() {
        }

        private Builder(ListMediaWorkflowExecutionsRequest request) {
            super((Request)request);
            this.inputFileURL = request.inputFileURL;
            this.maximumPageSize = request.maximumPageSize;
            this.mediaWorkflowId = request.mediaWorkflowId;
            this.mediaWorkflowName = request.mediaWorkflowName;
            this.nextPageToken = request.nextPageToken;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
        }

        public Builder inputFileURL(String inputFileURL) {
            this.putQueryParameter("InputFileURL", inputFileURL);
            this.inputFileURL = inputFileURL;
            return this;
        }

        public Builder maximumPageSize(Long maximumPageSize) {
            this.putQueryParameter("MaximumPageSize", maximumPageSize);
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        public Builder mediaWorkflowId(String mediaWorkflowId) {
            this.putQueryParameter("MediaWorkflowId", mediaWorkflowId);
            this.mediaWorkflowId = mediaWorkflowId;
            return this;
        }

        public Builder mediaWorkflowName(String mediaWorkflowName) {
            this.putQueryParameter("MediaWorkflowName", mediaWorkflowName);
            this.mediaWorkflowName = mediaWorkflowName;
            return this;
        }

        public Builder nextPageToken(String nextPageToken) {
            this.putQueryParameter("NextPageToken", nextPageToken);
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public ListMediaWorkflowExecutionsRequest build() {
            return new ListMediaWorkflowExecutionsRequest(this);
        }
    }
}

