/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.mts20140618.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryMediaWorkflowExecutionListRequest
extends Request {
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;
    @Query
    @NameInMap(value="RunIds")
    @Validation(required=true)
    private String runIds;

    private QueryMediaWorkflowExecutionListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.runIds = builder.runIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryMediaWorkflowExecutionListRequest create() {
        return QueryMediaWorkflowExecutionListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public String getRunIds() {
        return this.runIds;
    }

    public static final class Builder
    extends Request.Builder<QueryMediaWorkflowExecutionListRequest, Builder> {
        private String ownerAccount;
        private Long ownerId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;
        private String runIds;

        private Builder() {
        }

        private Builder(QueryMediaWorkflowExecutionListRequest request) {
            super((Request)request);
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
            this.runIds = request.runIds;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public Builder runIds(String runIds) {
            this.putQueryParameter("RunIds", runIds);
            this.runIds = runIds;
            return this;
        }

        public QueryMediaWorkflowExecutionListRequest build() {
            return new QueryMediaWorkflowExecutionListRequest(this);
        }
    }
}

