/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.mts20140618.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdatePipelineRequest
extends Request {
    @Query
    @NameInMap(value="Name")
    @Validation(required=true)
    private String name;
    @Query
    @NameInMap(value="NotifyConfig")
    private String notifyConfig;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PipelineId")
    @Validation(required=true)
    private String pipelineId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;
    @Query
    @NameInMap(value="Role")
    private String role;
    @Query
    @NameInMap(value="State")
    @Validation(required=true)
    private String state;

    private UpdatePipelineRequest(Builder builder) {
        super((Request.Builder)builder);
        this.name = builder.name;
        this.notifyConfig = builder.notifyConfig;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.pipelineId = builder.pipelineId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.role = builder.role;
        this.state = builder.state;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdatePipelineRequest create() {
        return UpdatePipelineRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getName() {
        return this.name;
    }

    public String getNotifyConfig() {
        return this.notifyConfig;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public String getRole() {
        return this.role;
    }

    public String getState() {
        return this.state;
    }

    public static final class Builder
    extends Request.Builder<UpdatePipelineRequest, Builder> {
        private String name;
        private String notifyConfig;
        private String ownerAccount;
        private Long ownerId;
        private String pipelineId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;
        private String role;
        private String state;

        private Builder() {
        }

        private Builder(UpdatePipelineRequest request) {
            super((Request)request);
            this.name = request.name;
            this.notifyConfig = request.notifyConfig;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.pipelineId = request.pipelineId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
            this.role = request.role;
            this.state = request.state;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder notifyConfig(String notifyConfig) {
            this.putQueryParameter("NotifyConfig", notifyConfig);
            this.notifyConfig = notifyConfig;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder pipelineId(String pipelineId) {
            this.putQueryParameter("PipelineId", pipelineId);
            this.pipelineId = pipelineId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public Builder role(String role) {
            this.putQueryParameter("Role", role);
            this.role = role;
            return this;
        }

        public Builder state(String state) {
            this.putQueryParameter("State", state);
            this.state = state;
            return this;
        }

        public UpdatePipelineRequest build() {
            return new UpdatePipelineRequest(this);
        }
    }
}

