/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2;

import com.aliyun.sdk.service.oss2.Validate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AttributeMap {
    private final Map<Key<?>, Object> attributes;

    private AttributeMap(Map<? extends Key<?>, ?> attributes) {
        this.attributes = new HashMap(attributes);
    }

    public static AttributeMap empty() {
        return new AttributeMap(new HashMap());
    }

    public <T> boolean containsKey(Key<T> typedKey) {
        return this.attributes.containsKey(typedKey);
    }

    public <T> T get(Key<T> key) {
        Validate.notNull(key, "Key to retrieve must not be null.", new Object[0]);
        return key.convertValue(this.attributes.get(key));
    }

    public <T> AttributeMap put(Key<T> key, T value) {
        Validate.notNull(key, "Key to set must not be null.", new Object[0]);
        this.attributes.put(key, value);
        return this;
    }

    public <T> AttributeMap putIfAbsent(Key<T> key, T value) {
        Validate.notNull(key, "Key to set must not be null.", new Object[0]);
        this.attributes.putIfAbsent(key, value);
        return this;
    }

    public AttributeMap merge(AttributeMap lowerPrecedence) {
        HashMap copiedConfiguration = new HashMap(this.attributes);
        lowerPrecedence.attributes.forEach(copiedConfiguration::putIfAbsent);
        return new AttributeMap(copiedConfiguration);
    }

    public AttributeMap copy() {
        HashMap map = new HashMap();
        this.attributes.forEach((key, value) -> {
            key.validateValue(value);
            map.put(key, value);
        });
        return new AttributeMap(map);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AttributeMap)) {
            return false;
        }
        AttributeMap rhs = (AttributeMap)obj;
        if (this.attributes.size() != rhs.attributes.size()) {
            return false;
        }
        for (Key<?> lhsKey : this.attributes.keySet()) {
            Object rhsValue;
            Object lhsValue = this.get(lhsKey);
            if (Objects.equals(lhsValue, rhsValue = rhs.get(lhsKey))) continue;
            return false;
        }
        return true;
    }

    public static abstract class Key<T> {
        private final Class<?> valueType;

        protected Key(Class<T> valueType) {
            this.valueType = valueType;
        }

        protected Key(UnsafeValueType unsafeValueType) {
            this.valueType = unsafeValueType.valueType;
        }

        private static <T> void assertIsAssignableFrom(Class<T> superType, Class<?> type, String message, Object ... values) {
            if (!superType.isAssignableFrom(type)) {
                throw new IllegalArgumentException(String.format(message, values));
            }
        }

        final void validateValue(Object value) {
            if (value != null) {
                Key.assertIsAssignableFrom(this.valueType, value.getClass(), "Invalid option: %s. Required value of type %s, but was %s.", this, this.valueType, value.getClass());
            }
        }

        public final T convertValue(Object value) {
            this.validateValue(value);
            return (T)this.valueType.cast(value);
        }

        protected static class UnsafeValueType {
            private final Class<?> valueType;

            public UnsafeValueType(Class<?> valueType) {
                this.valueType = valueType;
            }
        }
    }
}

