/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2;

import com.aliyun.sdk.service.oss2.BaseClientBuilder;
import com.aliyun.sdk.service.oss2.ClientConfiguration;
import com.aliyun.sdk.service.oss2.credentials.CredentialsProvider;
import com.aliyun.sdk.service.oss2.retry.Retryer;
import com.aliyun.sdk.service.oss2.signer.Signer;
import com.aliyun.sdk.service.oss2.transport.HttpClient;
import com.aliyun.sdk.service.oss2.transport.HttpClientOptions;
import java.time.Duration;
import java.util.List;

public abstract class DefaultBaseClientBuilder<B extends BaseClientBuilder<B, C>, C>
implements BaseClientBuilder<B, C> {
    protected ClientConfiguration.Builder cfgBuilder = ClientConfiguration.defaultBuilder();
    protected HttpClient httpClient = null;

    @Override
    public final C build() {
        return this.buildClient();
    }

    protected abstract C buildClient();

    @Override
    public B region(String value) {
        this.cfgBuilder.region(value);
        return (B)this;
    }

    @Override
    public B endpoint(String value) {
        this.cfgBuilder.endpoint(value);
        return (B)this;
    }

    @Override
    public B signer(Signer value) {
        this.cfgBuilder.signer(value);
        return (B)this;
    }

    @Override
    public B retryMaxAttempts(Integer value) {
        this.cfgBuilder.retryMaxAttempts(value);
        return (B)this;
    }

    @Override
    public B retryer(Retryer value) {
        this.cfgBuilder.retryer(value);
        return (B)this;
    }

    @Override
    public B credentialsProvider(CredentialsProvider value) {
        this.cfgBuilder.credentialsProvider(value);
        return (B)this;
    }

    @Override
    public B signatureVersion(String value) {
        this.cfgBuilder.signatureVersion(value);
        return (B)this;
    }

    @Override
    public B disableSsl(Boolean value) {
        this.cfgBuilder.disableSsl(value);
        return (B)this;
    }

    @Override
    public B useDualStackEndpoint(Boolean value) {
        this.cfgBuilder.useDualStackEndpoint(value);
        return (B)this;
    }

    @Override
    public B useInternalEndpoint(Boolean value) {
        this.cfgBuilder.useInternalEndpoint(value);
        return (B)this;
    }

    @Override
    public B useAccelerateEndpoint(Boolean value) {
        this.cfgBuilder.useAccelerateEndpoint(value);
        return (B)this;
    }

    @Override
    public B useCName(Boolean value) {
        this.cfgBuilder.useCName(value);
        return (B)this;
    }

    @Override
    public B usePathStyle(Boolean value) {
        this.cfgBuilder.usePathStyle(value);
        return (B)this;
    }

    @Override
    public B httpClient(HttpClient value) {
        this.cfgBuilder.httpClient(value);
        this.httpClient = value;
        return (B)this;
    }

    @Override
    public B additionalHeaders(List<String> value) {
        this.cfgBuilder.additionalHeaders(value);
        return (B)this;
    }

    @Override
    public B userAgent(String value) {
        this.cfgBuilder.userAgent(value);
        return (B)this;
    }

    @Override
    public B connectTimeout(Duration value) {
        this.cfgBuilder.connectTimeout(value);
        return (B)this;
    }

    @Override
    public B readWriteTimeout(Duration value) {
        this.cfgBuilder.readWriteTimeout(value);
        return (B)this;
    }

    @Override
    public B insecureSkipVerify(boolean value) {
        this.cfgBuilder.insecureSkipVerify(value);
        return (B)this;
    }

    @Override
    public B enabledRedirect(boolean value) {
        this.cfgBuilder.enabledRedirect(value);
        return (B)this;
    }

    @Override
    public B proxyHost(String value) {
        this.cfgBuilder.proxyHost(value);
        return (B)this;
    }

    @Override
    public B disableUploadCRC64Check(boolean value) {
        this.cfgBuilder.disableUploadCRC64Check(value);
        return (B)this;
    }

    @Override
    public B accountId(String value) {
        this.cfgBuilder.accountId(value);
        return (B)this;
    }

    protected final HttpClientOptions toHttpClientOptions(ClientConfiguration cfg) {
        HttpClientOptions.Builder b = HttpClientOptions.custom();
        if (cfg.insecureSkipVerify().isPresent()) {
            b.insecureSkipVerify(cfg.insecureSkipVerify().get());
        }
        if (cfg.enabledRedirect().isPresent()) {
            b.redirectsEnabled(cfg.enabledRedirect().get());
        }
        if (cfg.connectTimeout().isPresent()) {
            b.connectTimeout(cfg.connectTimeout().get());
        }
        if (cfg.readWriteTimeout().isPresent()) {
            b.readWriteTimeout(cfg.readWriteTimeout().get());
        }
        if (cfg.proxyHost().isPresent()) {
            b.proxyHost(cfg.proxyHost().get());
        }
        return b.build();
    }
}

