/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2;

import com.aliyun.sdk.service.oss2.DefaultOSSAsyncClientBuilder;
import com.aliyun.sdk.service.oss2.OSSAsyncClientBuilder;
import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOptions;
import com.aliyun.sdk.service.oss2.OperationOutput;
import com.aliyun.sdk.service.oss2.exceptions.OperationException;
import com.aliyun.sdk.service.oss2.exceptions.ServiceException;
import com.aliyun.sdk.service.oss2.models.AbortMultipartUploadRequest;
import com.aliyun.sdk.service.oss2.models.AbortMultipartUploadResult;
import com.aliyun.sdk.service.oss2.models.AppendObjectRequest;
import com.aliyun.sdk.service.oss2.models.AppendObjectResult;
import com.aliyun.sdk.service.oss2.models.AsyncProcessObjectRequest;
import com.aliyun.sdk.service.oss2.models.AsyncProcessObjectResult;
import com.aliyun.sdk.service.oss2.models.CleanRestoredObjectRequest;
import com.aliyun.sdk.service.oss2.models.CleanRestoredObjectResult;
import com.aliyun.sdk.service.oss2.models.CompleteMultipartUploadRequest;
import com.aliyun.sdk.service.oss2.models.CompleteMultipartUploadResult;
import com.aliyun.sdk.service.oss2.models.CopyObjectRequest;
import com.aliyun.sdk.service.oss2.models.CopyObjectResult;
import com.aliyun.sdk.service.oss2.models.CreateBucketDataRedundancyTransitionRequest;
import com.aliyun.sdk.service.oss2.models.CreateBucketDataRedundancyTransitionResult;
import com.aliyun.sdk.service.oss2.models.DeleteBucketCorsRequest;
import com.aliyun.sdk.service.oss2.models.DeleteBucketCorsResult;
import com.aliyun.sdk.service.oss2.models.DeleteBucketDataRedundancyTransitionRequest;
import com.aliyun.sdk.service.oss2.models.DeleteBucketDataRedundancyTransitionResult;
import com.aliyun.sdk.service.oss2.models.DeleteBucketEncryptionRequest;
import com.aliyun.sdk.service.oss2.models.DeleteBucketEncryptionResult;
import com.aliyun.sdk.service.oss2.models.DeleteBucketLoggingRequest;
import com.aliyun.sdk.service.oss2.models.DeleteBucketLoggingResult;
import com.aliyun.sdk.service.oss2.models.DeleteBucketPolicyRequest;
import com.aliyun.sdk.service.oss2.models.DeleteBucketPolicyResult;
import com.aliyun.sdk.service.oss2.models.DeleteBucketPublicAccessBlockRequest;
import com.aliyun.sdk.service.oss2.models.DeleteBucketPublicAccessBlockResult;
import com.aliyun.sdk.service.oss2.models.DeleteBucketRequest;
import com.aliyun.sdk.service.oss2.models.DeleteBucketResult;
import com.aliyun.sdk.service.oss2.models.DeleteBucketTagsRequest;
import com.aliyun.sdk.service.oss2.models.DeleteBucketTagsResult;
import com.aliyun.sdk.service.oss2.models.DeleteMultipleObjectsRequest;
import com.aliyun.sdk.service.oss2.models.DeleteMultipleObjectsResult;
import com.aliyun.sdk.service.oss2.models.DeleteObjectRequest;
import com.aliyun.sdk.service.oss2.models.DeleteObjectResult;
import com.aliyun.sdk.service.oss2.models.DeleteObjectTaggingRequest;
import com.aliyun.sdk.service.oss2.models.DeleteObjectTaggingResult;
import com.aliyun.sdk.service.oss2.models.DeletePublicAccessBlockRequest;
import com.aliyun.sdk.service.oss2.models.DeletePublicAccessBlockResult;
import com.aliyun.sdk.service.oss2.models.DeleteUserDefinedLogFieldsConfigRequest;
import com.aliyun.sdk.service.oss2.models.DeleteUserDefinedLogFieldsConfigResult;
import com.aliyun.sdk.service.oss2.models.DescribeRegionsRequest;
import com.aliyun.sdk.service.oss2.models.DescribeRegionsResult;
import com.aliyun.sdk.service.oss2.models.GetBucketAccessMonitorRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketAccessMonitorResult;
import com.aliyun.sdk.service.oss2.models.GetBucketAclRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketAclResult;
import com.aliyun.sdk.service.oss2.models.GetBucketCorsRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketCorsResult;
import com.aliyun.sdk.service.oss2.models.GetBucketDataRedundancyTransitionRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketDataRedundancyTransitionResult;
import com.aliyun.sdk.service.oss2.models.GetBucketEncryptionRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketEncryptionResult;
import com.aliyun.sdk.service.oss2.models.GetBucketInfoRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketInfoResult;
import com.aliyun.sdk.service.oss2.models.GetBucketLocationRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketLocationResult;
import com.aliyun.sdk.service.oss2.models.GetBucketLoggingRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketLoggingResult;
import com.aliyun.sdk.service.oss2.models.GetBucketPolicyRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketPolicyResult;
import com.aliyun.sdk.service.oss2.models.GetBucketPolicyStatusRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketPolicyStatusResult;
import com.aliyun.sdk.service.oss2.models.GetBucketPublicAccessBlockRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketPublicAccessBlockResult;
import com.aliyun.sdk.service.oss2.models.GetBucketRefererRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketRefererResult;
import com.aliyun.sdk.service.oss2.models.GetBucketResourceGroupRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketResourceGroupResult;
import com.aliyun.sdk.service.oss2.models.GetBucketStatRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketStatResult;
import com.aliyun.sdk.service.oss2.models.GetBucketTagsRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketTagsResult;
import com.aliyun.sdk.service.oss2.models.GetBucketVersioningRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketVersioningResult;
import com.aliyun.sdk.service.oss2.models.GetObjectAclRequest;
import com.aliyun.sdk.service.oss2.models.GetObjectAclResult;
import com.aliyun.sdk.service.oss2.models.GetObjectMetaRequest;
import com.aliyun.sdk.service.oss2.models.GetObjectMetaResult;
import com.aliyun.sdk.service.oss2.models.GetObjectRequest;
import com.aliyun.sdk.service.oss2.models.GetObjectResult;
import com.aliyun.sdk.service.oss2.models.GetObjectTaggingRequest;
import com.aliyun.sdk.service.oss2.models.GetObjectTaggingResult;
import com.aliyun.sdk.service.oss2.models.GetPublicAccessBlockRequest;
import com.aliyun.sdk.service.oss2.models.GetPublicAccessBlockResult;
import com.aliyun.sdk.service.oss2.models.GetSymlinkRequest;
import com.aliyun.sdk.service.oss2.models.GetSymlinkResult;
import com.aliyun.sdk.service.oss2.models.GetUserDefinedLogFieldsConfigRequest;
import com.aliyun.sdk.service.oss2.models.GetUserDefinedLogFieldsConfigResult;
import com.aliyun.sdk.service.oss2.models.HeadObjectRequest;
import com.aliyun.sdk.service.oss2.models.HeadObjectResult;
import com.aliyun.sdk.service.oss2.models.InitiateMultipartUploadRequest;
import com.aliyun.sdk.service.oss2.models.InitiateMultipartUploadResult;
import com.aliyun.sdk.service.oss2.models.ListBucketDataRedundancyTransitionRequest;
import com.aliyun.sdk.service.oss2.models.ListBucketDataRedundancyTransitionResult;
import com.aliyun.sdk.service.oss2.models.ListBucketsRequest;
import com.aliyun.sdk.service.oss2.models.ListBucketsResult;
import com.aliyun.sdk.service.oss2.models.ListMultipartUploadsRequest;
import com.aliyun.sdk.service.oss2.models.ListMultipartUploadsResult;
import com.aliyun.sdk.service.oss2.models.ListObjectVersionsRequest;
import com.aliyun.sdk.service.oss2.models.ListObjectVersionsResult;
import com.aliyun.sdk.service.oss2.models.ListObjectsRequest;
import com.aliyun.sdk.service.oss2.models.ListObjectsResult;
import com.aliyun.sdk.service.oss2.models.ListObjectsV2Request;
import com.aliyun.sdk.service.oss2.models.ListObjectsV2Result;
import com.aliyun.sdk.service.oss2.models.ListPartsRequest;
import com.aliyun.sdk.service.oss2.models.ListPartsResult;
import com.aliyun.sdk.service.oss2.models.ListUserDataRedundancyTransitionRequest;
import com.aliyun.sdk.service.oss2.models.ListUserDataRedundancyTransitionResult;
import com.aliyun.sdk.service.oss2.models.OptionObjectRequest;
import com.aliyun.sdk.service.oss2.models.OptionObjectResult;
import com.aliyun.sdk.service.oss2.models.ProcessObjectRequest;
import com.aliyun.sdk.service.oss2.models.ProcessObjectResult;
import com.aliyun.sdk.service.oss2.models.PutBucketAccessMonitorRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketAccessMonitorResult;
import com.aliyun.sdk.service.oss2.models.PutBucketAclRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketAclResult;
import com.aliyun.sdk.service.oss2.models.PutBucketCorsRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketCorsResult;
import com.aliyun.sdk.service.oss2.models.PutBucketEncryptionRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketEncryptionResult;
import com.aliyun.sdk.service.oss2.models.PutBucketLoggingRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketLoggingResult;
import com.aliyun.sdk.service.oss2.models.PutBucketPolicyRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketPolicyResult;
import com.aliyun.sdk.service.oss2.models.PutBucketPublicAccessBlockRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketPublicAccessBlockResult;
import com.aliyun.sdk.service.oss2.models.PutBucketRefererRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketRefererResult;
import com.aliyun.sdk.service.oss2.models.PutBucketRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketResourceGroupRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketResourceGroupResult;
import com.aliyun.sdk.service.oss2.models.PutBucketResult;
import com.aliyun.sdk.service.oss2.models.PutBucketTagsRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketTagsResult;
import com.aliyun.sdk.service.oss2.models.PutBucketVersioningRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketVersioningResult;
import com.aliyun.sdk.service.oss2.models.PutObjectAclRequest;
import com.aliyun.sdk.service.oss2.models.PutObjectAclResult;
import com.aliyun.sdk.service.oss2.models.PutObjectRequest;
import com.aliyun.sdk.service.oss2.models.PutObjectResult;
import com.aliyun.sdk.service.oss2.models.PutObjectTaggingRequest;
import com.aliyun.sdk.service.oss2.models.PutObjectTaggingResult;
import com.aliyun.sdk.service.oss2.models.PutPublicAccessBlockRequest;
import com.aliyun.sdk.service.oss2.models.PutPublicAccessBlockResult;
import com.aliyun.sdk.service.oss2.models.PutSymlinkRequest;
import com.aliyun.sdk.service.oss2.models.PutSymlinkResult;
import com.aliyun.sdk.service.oss2.models.PutUserDefinedLogFieldsConfigRequest;
import com.aliyun.sdk.service.oss2.models.PutUserDefinedLogFieldsConfigResult;
import com.aliyun.sdk.service.oss2.models.RestoreObjectRequest;
import com.aliyun.sdk.service.oss2.models.RestoreObjectResult;
import com.aliyun.sdk.service.oss2.models.SealAppendObjectRequest;
import com.aliyun.sdk.service.oss2.models.SealAppendObjectResult;
import com.aliyun.sdk.service.oss2.models.UploadPartCopyRequest;
import com.aliyun.sdk.service.oss2.models.UploadPartCopyResult;
import com.aliyun.sdk.service.oss2.models.UploadPartRequest;
import com.aliyun.sdk.service.oss2.models.UploadPartResult;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.transport.BinaryDataConsumerSupplier;
import com.aliyun.sdk.service.oss2.utils.IOUtils;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CompletableFuture;

public interface OSSAsyncClient
extends AutoCloseable {
    public static OSSAsyncClientBuilder newBuilder() {
        return new DefaultOSSAsyncClientBuilder();
    }

    default public CompletableFuture<OperationOutput> invokeOperationAsync(OperationInput input, OperationOptions opts) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListBucketsResult> listBucketsAsync(ListBucketsRequest request) {
        return this.listBucketsAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<ListBucketsResult> listBucketsAsync(ListBucketsRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeRegionsResult> describeRegionsAsync(DescribeRegionsRequest request) {
        return this.describeRegionsAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DescribeRegionsResult> describeRegionsAsync(DescribeRegionsRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutObjectResult> putObjectAsync(PutObjectRequest request) {
        return this.putObjectAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutObjectResult> putObjectAsync(PutObjectRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CopyObjectResult> copyObjectAsync(CopyObjectRequest request) {
        return this.copyObjectAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<CopyObjectResult> copyObjectAsync(CopyObjectRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetObjectResult> getObjectAsync(GetObjectRequest request) {
        return this.getObjectAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetObjectResult> getObjectAsync(GetObjectRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<AppendObjectResult> appendObjectAsync(AppendObjectRequest request) {
        return this.appendObjectAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<AppendObjectResult> appendObjectAsync(AppendObjectRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteObjectResult> deleteObjectAsync(DeleteObjectRequest request) {
        return this.deleteObjectAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DeleteObjectResult> deleteObjectAsync(DeleteObjectRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteMultipleObjectsResult> deleteMultipleObjectsAsync(DeleteMultipleObjectsRequest request) {
        return this.deleteMultipleObjectsAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DeleteMultipleObjectsResult> deleteMultipleObjectsAsync(DeleteMultipleObjectsRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<HeadObjectResult> headObjectAsync(HeadObjectRequest request) {
        return this.headObjectAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<HeadObjectResult> headObjectAsync(HeadObjectRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetObjectMetaResult> getObjectMetaAsync(GetObjectMetaRequest request) {
        return this.getObjectMetaAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetObjectMetaResult> getObjectMetaAsync(GetObjectMetaRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<RestoreObjectResult> restoreObjectAsync(RestoreObjectRequest request) {
        return this.restoreObjectAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<RestoreObjectResult> restoreObjectAsync(RestoreObjectRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CleanRestoredObjectResult> cleanRestoredObjectAsync(CleanRestoredObjectRequest request) {
        return this.cleanRestoredObjectAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<CleanRestoredObjectResult> cleanRestoredObjectAsync(CleanRestoredObjectRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutObjectAclResult> putObjectAclAsync(PutObjectAclRequest request) {
        return this.putObjectAclAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutObjectAclResult> putObjectAclAsync(PutObjectAclRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetObjectAclResult> getObjectAclAsync(GetObjectAclRequest request) {
        return this.getObjectAclAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetObjectAclResult> getObjectAclAsync(GetObjectAclRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<InitiateMultipartUploadResult> initiateMultipartUploadAsync(InitiateMultipartUploadRequest request) {
        return this.initiateMultipartUploadAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<InitiateMultipartUploadResult> initiateMultipartUploadAsync(InitiateMultipartUploadRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UploadPartResult> uploadPartAsync(UploadPartRequest request) {
        return this.uploadPartAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<UploadPartResult> uploadPartAsync(UploadPartRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CompleteMultipartUploadResult> completeMultipartUploadAsync(CompleteMultipartUploadRequest request) {
        return this.completeMultipartUploadAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<CompleteMultipartUploadResult> completeMultipartUploadAsync(CompleteMultipartUploadRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UploadPartCopyResult> uploadPartCopyAsync(UploadPartCopyRequest request) {
        return this.uploadPartCopyAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<UploadPartCopyResult> uploadPartCopyAsync(UploadPartCopyRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<AbortMultipartUploadResult> abortMultipartUploadAsync(AbortMultipartUploadRequest request) {
        return this.abortMultipartUploadAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<AbortMultipartUploadResult> abortMultipartUploadAsync(AbortMultipartUploadRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListMultipartUploadsResult> listMultipartUploadsAsync(ListMultipartUploadsRequest request) {
        return this.listMultipartUploadsAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<ListMultipartUploadsResult> listMultipartUploadsAsync(ListMultipartUploadsRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListPartsResult> listPartsAsync(ListPartsRequest request) {
        return this.listPartsAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<ListPartsResult> listPartsAsync(ListPartsRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutSymlinkResult> putSymlinkAsync(PutSymlinkRequest request) {
        return this.putSymlinkAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutSymlinkResult> putSymlinkAsync(PutSymlinkRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetSymlinkResult> getSymlinkAsync(GetSymlinkRequest request) {
        return this.getSymlinkAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetSymlinkResult> getSymlinkAsync(GetSymlinkRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutObjectTaggingResult> putObjectTaggingAsync(PutObjectTaggingRequest request) {
        return this.putObjectTaggingAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutObjectTaggingResult> putObjectTaggingAsync(PutObjectTaggingRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetObjectTaggingResult> getObjectTaggingAsync(GetObjectTaggingRequest request) {
        return this.getObjectTaggingAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetObjectTaggingResult> getObjectTaggingAsync(GetObjectTaggingRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteObjectTaggingResult> deleteObjectTaggingAsync(DeleteObjectTaggingRequest request) {
        return this.deleteObjectTaggingAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DeleteObjectTaggingResult> deleteObjectTaggingAsync(DeleteObjectTaggingRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketStatResult> getBucketStatAsync(GetBucketStatRequest request) {
        return this.getBucketStatAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketStatResult> getBucketStatAsync(GetBucketStatRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutBucketResult> putBucketAsync(PutBucketRequest request) {
        return this.putBucketAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutBucketResult> putBucketAsync(PutBucketRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteBucketResult> deleteBucketAsync(DeleteBucketRequest request) {
        return this.deleteBucketAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DeleteBucketResult> deleteBucketAsync(DeleteBucketRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListObjectsResult> listObjectsAsync(ListObjectsRequest request) {
        return this.listObjectsAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<ListObjectsResult> listObjectsAsync(ListObjectsRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListObjectsV2Result> listObjectsV2Async(ListObjectsV2Request request) {
        return this.listObjectsV2Async(request, OperationOptions.defaults());
    }

    default public CompletableFuture<ListObjectsV2Result> listObjectsV2Async(ListObjectsV2Request request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketInfoResult> getBucketInfoAsync(GetBucketInfoRequest request) {
        return this.getBucketInfoAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketInfoResult> getBucketInfoAsync(GetBucketInfoRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketLocationResult> getBucketLocationAsync(GetBucketLocationRequest request) {
        return this.getBucketLocationAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketLocationResult> getBucketLocationAsync(GetBucketLocationRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutBucketCorsResult> putBucketCorsAsync(PutBucketCorsRequest request) {
        return this.putBucketCorsAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutBucketCorsResult> putBucketCorsAsync(PutBucketCorsRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketCorsResult> getBucketCorsAsync(GetBucketCorsRequest request) {
        return this.getBucketCorsAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketCorsResult> getBucketCorsAsync(GetBucketCorsRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteBucketCorsResult> deleteBucketCorsAsync(DeleteBucketCorsRequest request) {
        return this.deleteBucketCorsAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DeleteBucketCorsResult> deleteBucketCorsAsync(DeleteBucketCorsRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<OptionObjectResult> optionObjectAsync(OptionObjectRequest request) {
        return this.optionObjectAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<OptionObjectResult> optionObjectAsync(OptionObjectRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutBucketVersioningResult> putBucketVersioningAsync(PutBucketVersioningRequest request) {
        return this.putBucketVersioningAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutBucketVersioningResult> putBucketVersioningAsync(PutBucketVersioningRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketVersioningResult> getBucketVersioningAsync(GetBucketVersioningRequest request) {
        return this.getBucketVersioningAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketVersioningResult> getBucketVersioningAsync(GetBucketVersioningRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListObjectVersionsResult> listObjectVersionsAsync(ListObjectVersionsRequest request) {
        return this.listObjectVersionsAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<ListObjectVersionsResult> listObjectVersionsAsync(ListObjectVersionsRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutPublicAccessBlockResult> putPublicAccessBlockAsync(PutPublicAccessBlockRequest request) {
        return this.putPublicAccessBlockAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutPublicAccessBlockResult> putPublicAccessBlockAsync(PutPublicAccessBlockRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetPublicAccessBlockResult> getPublicAccessBlockAsync(GetPublicAccessBlockRequest request) {
        return this.getPublicAccessBlockAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetPublicAccessBlockResult> getPublicAccessBlockAsync(GetPublicAccessBlockRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeletePublicAccessBlockResult> deletePublicAccessBlockAsync(DeletePublicAccessBlockRequest request) {
        return this.deletePublicAccessBlockAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DeletePublicAccessBlockResult> deletePublicAccessBlockAsync(DeletePublicAccessBlockRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutBucketAclResult> putBucketAclAsync(PutBucketAclRequest request) {
        return this.putBucketAclAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutBucketAclResult> putBucketAclAsync(PutBucketAclRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketAclResult> getBucketAclAsync(GetBucketAclRequest request) {
        return this.getBucketAclAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketAclResult> getBucketAclAsync(GetBucketAclRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<Boolean> doesBucketExistAsync(String bucket) {
        return this.doesBucketExistAsync(GetBucketAclRequest.newBuilder().bucket(bucket).build());
    }

    default public CompletableFuture<Boolean> doesBucketExistAsync(GetBucketAclRequest request) {
        return this.getBucketAclAsync(request).handle((result, exception) -> {
            if (exception != null) {
                Throwable cause = exception.getCause();
                ServiceException err = ServiceException.asCause(cause);
                if (err != null) {
                    return !"NoSuchBucket".equals(err.errorCode());
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            return Boolean.TRUE;
        });
    }

    default public CompletableFuture<Boolean> doesObjectExistAsync(String bucket, String key) {
        return this.doesObjectExistAsync(GetObjectMetaRequest.newBuilder().bucket(bucket).key(key).build());
    }

    default public CompletableFuture<Boolean> doesObjectExistAsync(GetObjectMetaRequest request) {
        return this.getObjectMetaAsync(request).handle((result, exception) -> {
            if (exception != null) {
                Throwable cause = exception.getCause();
                ServiceException err = ServiceException.asCause(cause);
                if (err != null && ("NoSuchKey".equals(err.errorCode()) || err.statusCode() == 404 && "BadErrorResponse".equals(err.errorCode()))) {
                    return Boolean.FALSE;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            return Boolean.TRUE;
        });
    }

    default public CompletableFuture<Boolean> doesObjectExistLegacyAsync(String bucket, String key) {
        return this.doesObjectExistLegacyAsync(GetObjectMetaRequest.newBuilder().bucket(bucket).key(key).build());
    }

    default public CompletableFuture<Boolean> doesObjectExistLegacyAsync(GetObjectMetaRequest request) {
        return this.getObjectMetaAsync(request).handle((result, exception) -> {
            if (exception != null) {
                Throwable cause = exception.getCause();
                ServiceException err = ServiceException.asCause(cause);
                if (err != null && ("NoSuchBucket".equals(err.errorCode()) || "NoSuchKey".equals(err.errorCode()) || err.statusCode() == 404 && "BadErrorResponse".equals(err.errorCode()))) {
                    return Boolean.FALSE;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            return Boolean.TRUE;
        });
    }

    default public CompletableFuture<PutObjectResult> putObjectFromFileAsync(PutObjectRequest request, Path filePath) {
        return this.putObjectFromFileAsync(request, filePath, OperationOptions.defaults());
    }

    default public CompletableFuture<PutObjectResult> putObjectFromFileAsync(PutObjectRequest request, Path filePath, OperationOptions options) {
        CompletableFuture<PutObjectResult> future = new CompletableFuture<PutObjectResult>();
        try {
            FileChannel fileChannel = FileChannel.open(filePath, new OpenOption[0]);
            CompletableFuture<PutObjectResult> resultFuture = this.putObjectAsync(request.toBuilder().body(BinaryData.fromByteChannel(fileChannel, fileChannel.size())).build(), options);
            resultFuture.whenComplete((result, exception) -> {
                IOUtils.closeQuietly(fileChannel);
                if (exception != null) {
                    future.completeExceptionally(exception.getCause());
                    return;
                }
                future.complete((PutObjectResult)result);
            });
        }
        catch (Exception e) {
            future.completeExceptionally(new OperationException("PutObject", e));
        }
        return future;
    }

    default public CompletableFuture<GetObjectResult> getObjectToFileAsync(GetObjectRequest request, Path filePath) {
        return this.getObjectToFileAsync(request, filePath, OperationOptions.defaults());
    }

    default public CompletableFuture<GetObjectResult> getObjectToFileAsync(GetObjectRequest request, final Path filePath, OperationOptions options) {
        return this.getObjectAsync(request.toBuilder().dataConsumerSupplier(new BinaryDataConsumerSupplier(){

            @Override
            public Object get() {
                try {
                    return FileChannel.open(filePath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                }
                catch (IOException e) {
                    throw new RuntimeException("Open channel fail.", e);
                }
            }

            @Override
            public boolean isReplayable() {
                return true;
            }

            @Override
            public boolean autoRelease() {
                return true;
            }
        }).build(), options).thenApply(x -> ((GetObjectResult.Builder)x.toBuilder().innerBody(null)).build());
    }

    default public CompletableFuture<PutBucketPolicyResult> putBucketPolicyAsync(PutBucketPolicyRequest request) {
        return this.putBucketPolicyAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutBucketPolicyResult> putBucketPolicyAsync(PutBucketPolicyRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketPolicyResult> getBucketPolicyAsync(GetBucketPolicyRequest request) {
        return this.getBucketPolicyAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketPolicyResult> getBucketPolicyAsync(GetBucketPolicyRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteBucketPolicyResult> deleteBucketPolicyAsync(DeleteBucketPolicyRequest request) {
        return this.deleteBucketPolicyAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DeleteBucketPolicyResult> deleteBucketPolicyAsync(DeleteBucketPolicyRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketPolicyStatusResult> getBucketPolicyStatusAsync(GetBucketPolicyStatusRequest request) {
        return this.getBucketPolicyStatusAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketPolicyStatusResult> getBucketPolicyStatusAsync(GetBucketPolicyStatusRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutBucketAccessMonitorResult> putBucketAccessMonitorAsync(PutBucketAccessMonitorRequest request) {
        return this.putBucketAccessMonitorAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutBucketAccessMonitorResult> putBucketAccessMonitorAsync(PutBucketAccessMonitorRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketAccessMonitorResult> getBucketAccessMonitorAsync(GetBucketAccessMonitorRequest request) {
        return this.getBucketAccessMonitorAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketAccessMonitorResult> getBucketAccessMonitorAsync(GetBucketAccessMonitorRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutBucketResourceGroupResult> putBucketResourceGroupAsync(PutBucketResourceGroupRequest request) {
        return this.putBucketResourceGroupAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutBucketResourceGroupResult> putBucketResourceGroupAsync(PutBucketResourceGroupRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketResourceGroupResult> getBucketResourceGroupAsync(GetBucketResourceGroupRequest request) {
        return this.getBucketResourceGroupAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketResourceGroupResult> getBucketResourceGroupAsync(GetBucketResourceGroupRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SealAppendObjectResult> sealAppendObjectAsync(SealAppendObjectRequest request) {
        return this.sealAppendObjectAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<SealAppendObjectResult> sealAppendObjectAsync(SealAppendObjectRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ProcessObjectResult> processObjectAsync(ProcessObjectRequest request) {
        return this.processObjectAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<ProcessObjectResult> processObjectAsync(ProcessObjectRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<AsyncProcessObjectResult> asyncProcessObjectAsync(AsyncProcessObjectRequest request) {
        return this.asyncProcessObjectAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<AsyncProcessObjectResult> asyncProcessObjectAsync(AsyncProcessObjectRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateBucketDataRedundancyTransitionResult> createBucketDataRedundancyTransitionAsync(CreateBucketDataRedundancyTransitionRequest request) {
        return this.createBucketDataRedundancyTransitionAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<CreateBucketDataRedundancyTransitionResult> createBucketDataRedundancyTransitionAsync(CreateBucketDataRedundancyTransitionRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketDataRedundancyTransitionResult> getBucketDataRedundancyTransitionAsync(GetBucketDataRedundancyTransitionRequest request) {
        return this.getBucketDataRedundancyTransitionAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketDataRedundancyTransitionResult> getBucketDataRedundancyTransitionAsync(GetBucketDataRedundancyTransitionRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteBucketDataRedundancyTransitionResult> deleteBucketDataRedundancyTransitionAsync(DeleteBucketDataRedundancyTransitionRequest request) {
        return this.deleteBucketDataRedundancyTransitionAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DeleteBucketDataRedundancyTransitionResult> deleteBucketDataRedundancyTransitionAsync(DeleteBucketDataRedundancyTransitionRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListBucketDataRedundancyTransitionResult> listBucketDataRedundancyTransitionAsync(ListBucketDataRedundancyTransitionRequest request) {
        return this.listBucketDataRedundancyTransitionAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<ListBucketDataRedundancyTransitionResult> listBucketDataRedundancyTransitionAsync(ListBucketDataRedundancyTransitionRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListUserDataRedundancyTransitionResult> listUserDataRedundancyTransitionAsync(ListUserDataRedundancyTransitionRequest request) {
        return this.listUserDataRedundancyTransitionAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<ListUserDataRedundancyTransitionResult> listUserDataRedundancyTransitionAsync(ListUserDataRedundancyTransitionRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutBucketEncryptionResult> putBucketEncryptionAsync(PutBucketEncryptionRequest request) {
        return this.putBucketEncryptionAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutBucketEncryptionResult> putBucketEncryptionAsync(PutBucketEncryptionRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketEncryptionResult> getBucketEncryptionAsync(GetBucketEncryptionRequest request) {
        return this.getBucketEncryptionAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketEncryptionResult> getBucketEncryptionAsync(GetBucketEncryptionRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteBucketEncryptionResult> deleteBucketEncryptionAsync(DeleteBucketEncryptionRequest request) {
        return this.deleteBucketEncryptionAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DeleteBucketEncryptionResult> deleteBucketEncryptionAsync(DeleteBucketEncryptionRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutBucketPublicAccessBlockResult> putBucketPublicAccessBlockAsync(PutBucketPublicAccessBlockRequest request) {
        return this.putBucketPublicAccessBlockAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutBucketPublicAccessBlockResult> putBucketPublicAccessBlockAsync(PutBucketPublicAccessBlockRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketPublicAccessBlockResult> getBucketPublicAccessBlockAsync(GetBucketPublicAccessBlockRequest request) {
        return this.getBucketPublicAccessBlockAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketPublicAccessBlockResult> getBucketPublicAccessBlockAsync(GetBucketPublicAccessBlockRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteBucketPublicAccessBlockResult> deleteBucketPublicAccessBlockAsync(DeleteBucketPublicAccessBlockRequest request) {
        return this.deleteBucketPublicAccessBlockAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DeleteBucketPublicAccessBlockResult> deleteBucketPublicAccessBlockAsync(DeleteBucketPublicAccessBlockRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutBucketLoggingResult> putBucketLoggingAsync(PutBucketLoggingRequest request) {
        return this.putBucketLoggingAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutBucketLoggingResult> putBucketLoggingAsync(PutBucketLoggingRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketLoggingResult> getBucketLoggingAsync(GetBucketLoggingRequest request) {
        return this.getBucketLoggingAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketLoggingResult> getBucketLoggingAsync(GetBucketLoggingRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteBucketLoggingResult> deleteBucketLoggingAsync(DeleteBucketLoggingRequest request) {
        return this.deleteBucketLoggingAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DeleteBucketLoggingResult> deleteBucketLoggingAsync(DeleteBucketLoggingRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutUserDefinedLogFieldsConfigResult> putUserDefinedLogFieldsConfigAsync(PutUserDefinedLogFieldsConfigRequest request) {
        return this.putUserDefinedLogFieldsConfigAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutUserDefinedLogFieldsConfigResult> putUserDefinedLogFieldsConfigAsync(PutUserDefinedLogFieldsConfigRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetUserDefinedLogFieldsConfigResult> getUserDefinedLogFieldsConfigAsync(GetUserDefinedLogFieldsConfigRequest request) {
        return this.getUserDefinedLogFieldsConfigAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetUserDefinedLogFieldsConfigResult> getUserDefinedLogFieldsConfigAsync(GetUserDefinedLogFieldsConfigRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteUserDefinedLogFieldsConfigResult> deleteUserDefinedLogFieldsConfigAsync(DeleteUserDefinedLogFieldsConfigRequest request) {
        return this.deleteUserDefinedLogFieldsConfigAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DeleteUserDefinedLogFieldsConfigResult> deleteUserDefinedLogFieldsConfigAsync(DeleteUserDefinedLogFieldsConfigRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutBucketTagsResult> putBucketTagsAsync(PutBucketTagsRequest request) {
        return this.putBucketTagsAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutBucketTagsResult> putBucketTagsAsync(PutBucketTagsRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketTagsResult> getBucketTagsAsync(GetBucketTagsRequest request) {
        return this.getBucketTagsAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketTagsResult> getBucketTagsAsync(GetBucketTagsRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteBucketTagsResult> deleteBucketTagsAsync(DeleteBucketTagsRequest request) {
        return this.deleteBucketTagsAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<DeleteBucketTagsResult> deleteBucketTagsAsync(DeleteBucketTagsRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutBucketRefererResult> putBucketRefererAsync(PutBucketRefererRequest request) {
        return this.putBucketRefererAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<PutBucketRefererResult> putBucketRefererAsync(PutBucketRefererRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetBucketRefererResult> getBucketRefererAsync(GetBucketRefererRequest request) {
        return this.getBucketRefererAsync(request, OperationOptions.defaults());
    }

    default public CompletableFuture<GetBucketRefererResult> getBucketRefererAsync(GetBucketRefererRequest request, OperationOptions options) {
        throw new UnsupportedOperationException();
    }
}

