/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2;

import com.aliyun.sdk.service.oss2.types.AuthMethodType;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class OperationOptions {
    private static final OperationOptions DEFAULT = OperationOptions.newBuilder().build();
    private final Integer retryMaxAttempts;
    private final Duration readWriteTimeout;
    private final AuthMethodType authMethod;

    private OperationOptions(Builder builder) {
        this.retryMaxAttempts = builder.retryMaxAttempts;
        this.readWriteTimeout = builder.readWriteTimeout;
        this.authMethod = builder.authMethod;
    }

    public static OperationOptions defaults() {
        return DEFAULT;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Integer> retryMaxAttempts() {
        return Optional.ofNullable(this.retryMaxAttempts);
    }

    public Optional<Duration> readWriteTimeout() {
        return Optional.ofNullable(this.readWriteTimeout);
    }

    public Optional<AuthMethodType> authMethod() {
        return Optional.ofNullable(this.authMethod);
    }

    public static class Builder {
        private Integer retryMaxAttempts;
        private Duration readWriteTimeout;
        private AuthMethodType authMethod;

        protected Builder() {
        }

        public Builder retryMaxAttempts(Integer retryMaxAttempts) {
            Objects.requireNonNull(retryMaxAttempts);
            this.retryMaxAttempts = retryMaxAttempts;
            return this;
        }

        public Builder readWriteTimeout(Duration readWriteTimeout) {
            Objects.requireNonNull(readWriteTimeout);
            this.readWriteTimeout = readWriteTimeout;
            return this;
        }

        public Builder authMethod(AuthMethodType authMethod) {
            Objects.requireNonNull(authMethod);
            this.authMethod = authMethod;
            return this;
        }

        public OperationOptions build() {
            return new OperationOptions(this);
        }
    }
}

