/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

public class PresignOptions {
    private static final PresignOptions DEFAULT = PresignOptions.newBuilder().build();
    private final Instant expiration;

    private PresignOptions(Builder builder) {
        this.expiration = builder.expiration;
    }

    public static PresignOptions defaults() {
        return DEFAULT;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Instant> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    public static class Builder {
        private Instant expiration;

        protected Builder() {
        }

        public Builder expiration(Instant value) {
            Objects.requireNonNull(value);
            this.expiration = value;
            return this;
        }

        public Builder expiration(Duration value) {
            Objects.requireNonNull(value);
            this.expiration = Instant.now().plusSeconds(value.getSeconds());
            return this;
        }

        public PresignOptions build() {
            return new PresignOptions(this);
        }
    }
}

