/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.encryption;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.SecretKey;

public class ContentCryptoMaterial
implements Serializable {
    private static final long serialVersionUID = -2728152316155503945L;
    protected transient SecretKey cek;
    protected transient byte[] iv;
    protected String contentCryptoAlgorithm;
    protected byte[] encryptedCEK;
    protected byte[] encryptedIV;
    protected String keyWrapAlgorithm;
    protected Map<String, String> matdesc;

    public ContentCryptoMaterial() {
    }

    public ContentCryptoMaterial(SecretKey cek, byte[] iv, String contentCryptoAlgorithm, byte[] encryptedCEK, byte[] encryptedIV, String keyWrapAlgorithm, Map<String, String> matDesc) {
        this.cek = cek;
        this.iv = (byte[])iv.clone();
        this.contentCryptoAlgorithm = contentCryptoAlgorithm;
        this.encryptedCEK = (byte[])encryptedCEK.clone();
        this.encryptedIV = (byte[])encryptedIV.clone();
        this.keyWrapAlgorithm = keyWrapAlgorithm;
        this.matdesc = Collections.unmodifiableMap(new TreeMap<String, String>(matDesc));
    }

    public int hashCode() {
        int i;
        int prime = 31;
        int result = 1;
        if (this.cek != null) {
            for (i = 0; i < this.cek.getEncoded().length; ++i) {
                result = 31 * result + this.cek.getEncoded()[i];
            }
        }
        if (this.iv != null) {
            for (i = 0; i < this.iv.length; ++i) {
                result = 31 * result + this.iv[i];
            }
        }
        if (this.encryptedCEK != null) {
            for (i = 0; i < this.encryptedCEK.length; ++i) {
                result = 31 * result + this.encryptedCEK[i];
            }
        }
        if (this.encryptedIV != null) {
            for (i = 0; i < this.encryptedIV.length; ++i) {
                result = 31 * result + this.encryptedIV[i];
            }
        }
        result = 31 * result + (this.contentCryptoAlgorithm == null ? 0 : this.contentCryptoAlgorithm.hashCode());
        result = 31 * result + (this.keyWrapAlgorithm == null ? 0 : this.keyWrapAlgorithm.hashCode());
        result = 31 * result + (this.matdesc == null ? 0 : this.matdesc.hashCode());
        return result;
    }

    public String getContentCryptoAlgorithm() {
        return this.contentCryptoAlgorithm;
    }

    public void setContentCryptoAlgorithm(String contentCryptoAlgorithm) {
        this.contentCryptoAlgorithm = contentCryptoAlgorithm;
    }

    public SecretKey getCEK() {
        return this.cek;
    }

    public void setCEK(SecretKey cek) {
        this.cek = cek;
    }

    public byte[] getIV() {
        return (byte[])this.iv.clone();
    }

    public void setIV(byte[] iv) {
        this.iv = iv;
    }

    public byte[] getEncryptedCEK() {
        return (byte[])this.encryptedCEK.clone();
    }

    public void setEncryptedCEK(byte[] encryptedCEK) {
        this.encryptedCEK = (byte[])encryptedCEK.clone();
    }

    public byte[] getEncryptedIV() {
        return (byte[])this.encryptedIV.clone();
    }

    public void setEncryptedIV(byte[] encryptedIV) {
        this.encryptedIV = (byte[])encryptedIV.clone();
    }

    public String getKeyWrapAlgorithm() {
        return this.keyWrapAlgorithm;
    }

    public void setKeyWrapAlgorithm(String keyWrapAlgorithm) {
        this.keyWrapAlgorithm = keyWrapAlgorithm;
    }

    public Map<String, String> getMaterialsDescription() {
        return this.matdesc;
    }

    public void setMaterialsDescription(Map<String, String> matdesc) {
        this.matdesc = Collections.unmodifiableMap(new TreeMap<String, String>(matdesc));
    }
}

