/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.encryption;

import com.aliyun.sdk.service.oss2.encryption.ContentCryptoMode;
import com.aliyun.sdk.service.oss2.encryption.CryptoStorageMethod;
import java.io.Serializable;
import java.security.Provider;
import java.security.SecureRandom;

public class CryptoConfiguration
implements Cloneable,
Serializable {
    public static final CryptoConfiguration DEFAULT = new CryptoConfiguration();
    private static final long serialVersionUID = -610360281849259785L;
    private static final SecureRandom SRAND = new SecureRandom();
    private ContentCryptoMode contentCryptoMode;
    private CryptoStorageMethod storageMethod;
    private Provider contentCryptoProvider;
    private SecureRandom secureRandom;

    public CryptoConfiguration() {
        this.contentCryptoMode = ContentCryptoMode.AES_CTR_MODE;
        this.storageMethod = CryptoStorageMethod.ObjectMetadata;
        this.secureRandom = SRAND;
        this.contentCryptoProvider = null;
    }

    public CryptoConfiguration(ContentCryptoMode contentCryptoMode, CryptoStorageMethod storageMethod, SecureRandom secureRandom, Provider contentCryptoProvider) {
        this.contentCryptoMode = contentCryptoMode;
        this.storageMethod = storageMethod;
        this.secureRandom = secureRandom;
        this.contentCryptoProvider = contentCryptoProvider;
    }

    public ContentCryptoMode getContentCryptoMode() {
        return this.contentCryptoMode;
    }

    public void setContentCryptoMode(ContentCryptoMode contentCryptoMode) {
        this.contentCryptoMode = contentCryptoMode;
    }

    public CryptoStorageMethod getStorageMethod() {
        return this.storageMethod;
    }

    public void setStorageMethod(CryptoStorageMethod storageMethod) {
        this.storageMethod = storageMethod;
    }

    public CryptoConfiguration withSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public CryptoConfiguration withContentCryptoProvider(Provider contentCryptoProvider) {
        this.contentCryptoProvider = contentCryptoProvider;
        return this;
    }

    public Provider getContentCryptoProvider() {
        return this.contentCryptoProvider;
    }

    public void setContentCryptoProvider(Provider contentCryptoProvider) {
        this.contentCryptoProvider = contentCryptoProvider;
    }

    public CryptoConfiguration clone() {
        CryptoConfiguration config = new CryptoConfiguration();
        config.setContentCryptoMode(this.contentCryptoMode);
        config.setSecureRandom(this.secureRandom);
        config.setStorageMethod(this.storageMethod);
        config.setContentCryptoProvider(this.contentCryptoProvider);
        return config;
    }
}

