/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.encryption;

import com.aliyun.sdk.service.oss2.encryption.ContentCryptoMaterial;
import com.aliyun.sdk.service.oss2.encryption.EncryptionMaterials;
import com.aliyun.sdk.service.oss2.encryption.crypto.CryptoRuntime;
import com.aliyun.sdk.service.oss2.utils.Base64Utils;
import java.lang.reflect.Field;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class SimpleRSAEncryptionMaterials
implements EncryptionMaterials {
    public static final String KEY_WRAP_ALGORITHM = "RSA/NONE/PKCS1Padding";
    private final LinkedHashMap<KeyPair, Map<String, String>> keyPairDescMaterials = new LinkedHashMap();
    private final KeyPair keyPair;
    private final Map<String, String> desc;

    public SimpleRSAEncryptionMaterials(KeyPair keyPair) {
        this.assertParameterNotNull(keyPair, "KeyPair");
        this.keyPair = keyPair;
        this.desc = new HashMap<String, String>();
        this.keyPairDescMaterials.put(keyPair, this.desc);
    }

    public SimpleRSAEncryptionMaterials(KeyPair keyPair, Map<String, String> desc) {
        this.assertParameterNotNull(keyPair, "KeyPair");
        this.keyPair = keyPair;
        this.desc = desc == null ? new HashMap<String, String>() : new HashMap<String, String>(desc);
        this.keyPairDescMaterials.put(keyPair, desc);
    }

    public static RSAPrivateKey getPrivateKeyFromPemPKCS1(String privateKeyStr) {
        try {
            String adjustStr = privateKeyStr.replace("-----BEGIN PRIVATE KEY-----", "");
            adjustStr = adjustStr.replace("-----BEGIN RSA PRIVATE KEY-----", "");
            adjustStr = adjustStr.replace("-----END PRIVATE KEY-----", "");
            adjustStr = adjustStr.replace("-----END RSA PRIVATE KEY-----", "");
            adjustStr = adjustStr.replace("\n", "");
            CryptoRuntime.enableBouncyCastle();
            byte[] buffer = Base64Utils.decodeString(adjustStr);
            RSAPrivateKeySpec keySpec = CryptoRuntime.convertPemPKCS1ToPrivateKey(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException("get private key from PKCS1 pem String error." + e.getMessage(), e);
        }
    }

    public static RSAPrivateKey getPrivateKeyFromPemPKCS8(String privateKeyStr) {
        try {
            String adjustStr = privateKeyStr.replace("-----BEGIN PRIVATE KEY-----", "");
            adjustStr = adjustStr.replace("-----BEGIN RSA PRIVATE KEY-----", "");
            adjustStr = adjustStr.replace("-----END PRIVATE KEY-----", "");
            adjustStr = adjustStr.replace("-----END RSA PRIVATE KEY-----", "");
            adjustStr = adjustStr.replace("\n", "");
            byte[] buffer = Base64Utils.decodeString(adjustStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException("Get private key from PKCS8 pem String error: " + e.getMessage(), e);
        }
    }

    public static RSAPublicKey getPublicKeyFromPemX509(String publicKeyStr) {
        try {
            String adjustStr = publicKeyStr.replace("-----BEGIN PUBLIC KEY-----", "");
            adjustStr = adjustStr.replace("-----BEGIN RSA PUBLIC KEY-----", "");
            adjustStr = adjustStr.replace("-----END PUBLIC KEY-----", "");
            adjustStr = adjustStr.replace("-----END RSA PUBLIC KEY-----", "");
            adjustStr = adjustStr.replace("\n", "");
            byte[] buffer = Base64Utils.decodeString(adjustStr);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException("Get public key from X509 pem String error." + e.getMessage(), e);
        }
    }

    public synchronized void addKeyPairDescMaterial(KeyPair keyPair, Map<String, String> description) {
        this.assertParameterNotNull(keyPair, "keyPair");
        if (description != null) {
            this.keyPairDescMaterials.put(keyPair, new HashMap<String, String>(description));
        } else {
            this.keyPairDescMaterials.put(keyPair, new HashMap());
        }
    }

    private KeyPair findKeyPairByDescription(Map<String, String> desc) {
        if (desc == null) {
            return null;
        }
        for (Map.Entry<KeyPair, Map<String, String>> entry : this.keyPairDescMaterials.entrySet()) {
            if (!desc.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private <K, V> Map.Entry<K, V> getTailByReflection(LinkedHashMap<K, V> map) throws NoSuchFieldException, IllegalAccessException {
        Field tail = map.getClass().getDeclaredField("tail");
        tail.setAccessible(true);
        return (Map.Entry)tail.get(map);
    }

    @Override
    public void encryptCEK(ContentCryptoMaterial contentMaterial) {
        this.assertParameterNotNull(contentMaterial, "ContentCryptoMaterialRW");
        this.assertParameterNotNull(contentMaterial.getCEK(), "ContentCryptoMaterialRW#getCEK()");
        this.assertParameterNotNull(contentMaterial.getIV(), "ContentCryptoMaterialRW#getIV()");
        try {
            PublicKey key = this.keyPair.getPublic();
            Cipher cipher = Cipher.getInstance(KEY_WRAP_ALGORITHM);
            cipher.init(1, (Key)key, new SecureRandom());
            byte[] encryptedCEK = cipher.doFinal(contentMaterial.getCEK().getEncoded());
            byte[] encryptedIV = cipher.doFinal(contentMaterial.getIV());
            contentMaterial.setEncryptedCEK(encryptedCEK);
            contentMaterial.setEncryptedIV(encryptedIV);
            contentMaterial.setKeyWrapAlgorithm(KEY_WRAP_ALGORITHM);
            contentMaterial.setMaterialsDescription(this.desc);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to encrypt content encryption key or iv." + e.getMessage(), e);
        }
    }

    @Override
    public void decryptCEK(ContentCryptoMaterial contentMaterial) {
        this.assertParameterNotNull(contentMaterial, "ContentCryptoMaterialRW");
        this.assertParameterNotNull(contentMaterial.getEncryptedCEK(), "ContentCryptoMaterialRW#getEncryptedCEK");
        this.assertParameterNotNull(contentMaterial.getEncryptedIV(), "ContentCryptoMaterialRW#getEncryptedIV");
        this.assertParameterNotNull(contentMaterial.getKeyWrapAlgorithm(), "ContentCryptoMaterialRW#getKeyWrapAlgorithm");
        if (!contentMaterial.getKeyWrapAlgorithm().equalsIgnoreCase(KEY_WRAP_ALGORITHM)) {
            throw new RuntimeException("Unrecognize your object key wrap algorithm: " + contentMaterial.getKeyWrapAlgorithm(), null);
        }
        try {
            KeyPair keyPair = this.findKeyPairByDescription(contentMaterial.getMaterialsDescription());
            if (keyPair == null) {
                Map.Entry<KeyPair, Map<String, String>> entry = this.getTailByReflection(this.keyPairDescMaterials);
                keyPair = entry.getKey();
            }
            PrivateKey key = keyPair.getPrivate();
            Cipher cipher = Cipher.getInstance(KEY_WRAP_ALGORITHM);
            cipher.init(2, key);
            byte[] cekBytes = cipher.doFinal(contentMaterial.getEncryptedCEK());
            byte[] iv = cipher.doFinal(contentMaterial.getEncryptedIV());
            SecretKeySpec cek = new SecretKeySpec(cekBytes, "");
            contentMaterial.setCEK(cek);
            contentMaterial.setIV(iv);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to decrypt the secured content key and iv. " + e.getMessage(), e);
        }
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    static {
        CryptoRuntime.enableBouncyCastle();
    }
}

