/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.encryption.crypto;

import com.aliyun.sdk.service.oss2.encryption.crypto.CryptoScheme;

public class AesCtr
extends CryptoScheme {
    @Override
    public String getKeyGeneratorAlgorithm() {
        return "AES";
    }

    @Override
    public int getKeyLengthInBits() {
        return 256;
    }

    @Override
    public String getContentCipherAlgorithm() {
        return "AES/CTR/NoPadding";
    }

    @Override
    public int getContentCipherIVLength() {
        return 16;
    }

    @Override
    public byte[] adjustIV(byte[] iv, long dataStartPos) {
        if (iv.length != 16) {
            throw new UnsupportedOperationException();
        }
        int blockSize = 16;
        long remainder = dataStartPos % 16L;
        if (remainder != 0L) {
            throw new IllegalArgumentException("Expected data start pos should be multiple of 16,but it was: " + dataStartPos);
        }
        long blockOffset = dataStartPos / 16L;
        byte[] J0 = this.computeJ0(iv);
        return AesCtr.incrementBlocks(J0, blockOffset);
    }

    private byte[] computeJ0(byte[] nonce) {
        int blockSize = 16;
        byte[] J0 = new byte[16];
        System.arraycopy(nonce, 0, J0, 0, nonce.length);
        return J0;
    }
}

