/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.encryption.crypto;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.security.spec.RSAPrivateKeySpec;

public class CryptoRuntime {
    static final String BOUNCY_CASTLE_PROVIDER = "BC";
    private static final String BC_PROVIDER_FQCN = "org.bouncycastle.jce.provider.BouncyCastleProvider";

    public static void enableBouncyCastle() {
        if (!CryptoRuntime.isBouncyCastleAvailable()) {
            CryptoRuntime.addBouncyCastleProvider();
            if (!CryptoRuntime.isBouncyCastleAvailable()) {
                throw new UnsupportedOperationException("The Bouncy castle library is not found.");
            }
        }
    }

    public static RSAPrivateKeySpec convertPemPKCS1ToPrivateKey(byte[] buffer) {
        try {
            Class<?> clz = Class.forName("org.bouncycastle.asn1.pkcs.RSAPrivateKey");
            Method method = clz.getMethod("getInstance", Object.class);
            Object obj = method.invoke(null, new Object[]{buffer});
            clz = Class.forName("org.bouncycastle.asn1.pkcs.RSAPrivateKey");
            method = clz.getMethod("getModulus", null);
            BigInteger modulus = (BigInteger)method.invoke(obj, null);
            method = clz.getMethod("getPrivateExponent", null);
            BigInteger exponent = (BigInteger)method.invoke(obj, null);
            return new RSAPrivateKeySpec(modulus, exponent);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("convertPemPKCS1ToPrivateKey fail.");
        }
    }

    private static synchronized boolean isBouncyCastleAvailable() {
        return Security.getProvider(BOUNCY_CASTLE_PROVIDER) != null;
    }

    private static synchronized void addBouncyCastleProvider() {
        if (CryptoRuntime.isBouncyCastleAvailable()) {
            return;
        }
        try {
            Class<?> c = Class.forName(BC_PROVIDER_FQCN);
            Provider provider = (Provider)c.newInstance();
            Security.addProvider(provider);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

