/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.encryption.crypto;

import com.aliyun.sdk.service.oss2.encryption.crypto.AesCtr;
import com.aliyun.sdk.service.oss2.encryption.crypto.CryptoCipher;
import com.aliyun.sdk.service.oss2.encryption.crypto.CryptoRuntime;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public abstract class CryptoScheme {
    public static final int BLOCK_SIZE = 16;
    public static final CryptoScheme AES_CTR = new AesCtr();

    public static byte[] incrementBlocks(byte[] counter, long blockDelta) {
        if (blockDelta == 0L) {
            return counter;
        }
        if (counter == null || counter.length != 16) {
            throw new IllegalArgumentException();
        }
        ByteBuffer bb = ByteBuffer.allocate(8);
        for (int i = 12; i <= 15; ++i) {
            bb.put(i - 8, counter[i]);
        }
        long val = bb.getLong() + blockDelta;
        bb.rewind();
        byte[] result = bb.putLong(val).array();
        System.arraycopy(result, 0, counter, 8, 8);
        return counter;
    }

    public static CryptoScheme fromCEKAlgo(String cekAlgo) {
        if (AES_CTR.getContentCipherAlgorithm().equals(cekAlgo)) {
            return AES_CTR;
        }
        throw new UnsupportedOperationException("Unsupported content encryption scheme: " + cekAlgo);
    }

    public abstract String getKeyGeneratorAlgorithm();

    public abstract int getKeyLengthInBits();

    public abstract String getContentCipherAlgorithm();

    public abstract int getContentCipherIVLength();

    public abstract byte[] adjustIV(byte[] var1, long var2);

    public CryptoCipher newCryptoCipher(Cipher cipher, SecretKey cek, int cipherMode) {
        return new CryptoCipher(cipher, this, cek, cipherMode);
    }

    public CryptoCipher createCryptoCipher(SecretKey cek, byte[] iv, int cipherMode, Provider provider) {
        try {
            Cipher cipher = null;
            cipher = provider != null ? Cipher.getInstance(this.getContentCipherAlgorithm(), provider) : Cipher.getInstance(this.getContentCipherAlgorithm());
            cipher.init(cipherMode, (Key)cek, new IvParameterSpec(iv));
            return this.newCryptoCipher(cipher, cek, cipherMode);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to build cipher: " + e.getMessage(), e);
        }
    }

    static {
        CryptoRuntime.enableBouncyCastle();
    }
}

