/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.encryption.internal;

import com.aliyun.sdk.service.oss2.encryption.ContentCryptoMaterial;
import com.aliyun.sdk.service.oss2.encryption.ContentCryptoMode;
import com.aliyun.sdk.service.oss2.encryption.CryptoConfiguration;
import com.aliyun.sdk.service.oss2.encryption.EncryptionMaterials;
import com.aliyun.sdk.service.oss2.encryption.crypto.CryptoCipher;
import com.aliyun.sdk.service.oss2.encryption.crypto.CryptoScheme;
import com.aliyun.sdk.service.oss2.encryption.internal.CryptoModuleBase;
import com.aliyun.sdk.service.oss2.encryption.internal.OSSDirect;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class CryptoModuleAesCtr
extends CryptoModuleBase {
    private final CryptoScheme contentCryptoScheme = CryptoScheme.AES_CTR;

    public CryptoModuleAesCtr(OSSDirect OSS, EncryptionMaterials encryptionMaterials, CryptoConfiguration cryptoConfig) {
        super(OSS, encryptionMaterials, cryptoConfig);
    }

    @Override
    final byte[] generateIV() {
        byte[] iv = new byte[this.contentCryptoScheme.getContentCipherIVLength()];
        this.cryptoConfig.getSecureRandom().nextBytes(iv);
        if (this.cryptoConfig.getContentCryptoMode().equals((Object)ContentCryptoMode.AES_CTR_MODE)) {
            for (int i = 8; i < 12; ++i) {
                iv[i] = 0;
            }
        }
        return iv;
    }

    @Override
    protected final SecretKey generateCEK() {
        String keygenAlgo = this.contentCryptoScheme.getKeyGeneratorAlgorithm();
        int keyLength = this.contentCryptoScheme.getKeyLengthInBits();
        try {
            KeyGenerator generator = KeyGenerator.getInstance(keygenAlgo);
            generator.init(keyLength, this.cryptoConfig.getSecureRandom());
            SecretKey secretKey = generator.generateKey();
            for (int retry = 0; retry < 9; ++retry) {
                secretKey = generator.generateKey();
                if (secretKey.getEncoded()[0] == 0) continue;
                return secretKey;
            }
            throw new RuntimeException("Failed to generate secret key", null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No such algorithm:" + keygenAlgo + ", " + e.getMessage(), e);
        }
    }

    @Override
    public String getContentCipherAlgorithm() {
        return this.contentCryptoScheme.getContentCipherAlgorithm();
    }

    @Override
    final CryptoCipher createEncryptCryptoCipher(ContentCryptoMaterial cekMaterial, long[] cryptoRange, long skipBlock) {
        return this.createCryptoCipherFromContentCryptoMaterial(cekMaterial, 1, cryptoRange, skipBlock);
    }

    @Override
    final CryptoCipher createDecryptCryptoCipher(ContentCryptoMaterial cekMaterial, long[] cryptoRange, long skipBlock) {
        return this.createCryptoCipherFromContentCryptoMaterial(cekMaterial, 2, cryptoRange, skipBlock);
    }

    private CryptoCipher createCryptoCipherFromContentCryptoMaterial(ContentCryptoMaterial cekMaterial, int cipherMode, long[] cryptoRange, long skipBlock) {
        boolean isRangeGet;
        if (cipherMode != 1 && cipherMode != 2) {
            throw new RuntimeException("Invalid cipher mode.", null);
        }
        byte[] iv = cekMaterial.getIV();
        SecretKey cek = cekMaterial.getCEK();
        String cekAlgo = cekMaterial.getContentCryptoAlgorithm();
        CryptoScheme tmpContentCryptoScheme = CryptoScheme.fromCEKAlgo(cekAlgo);
        boolean bl = isRangeGet = cryptoRange != null;
        if (isRangeGet) {
            iv = tmpContentCryptoScheme.adjustIV(iv, cryptoRange[0]);
        } else if (skipBlock > 0L) {
            iv = CryptoScheme.incrementBlocks(iv, skipBlock);
        }
        return tmpContentCryptoScheme.createCryptoCipher(cek, iv, cipherMode, this.cryptoConfig.getContentCryptoProvider());
    }
}

