/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.encryption.internal;

import com.aliyun.sdk.service.oss2.encryption.ContentCryptoMaterial;
import com.aliyun.sdk.service.oss2.encryption.CryptoConfiguration;
import com.aliyun.sdk.service.oss2.encryption.EncryptionMaterials;
import com.aliyun.sdk.service.oss2.encryption.crypto.CryptoCipher;
import com.aliyun.sdk.service.oss2.encryption.internal.CryptoModule;
import com.aliyun.sdk.service.oss2.encryption.internal.CryptoUtils;
import com.aliyun.sdk.service.oss2.encryption.internal.OSSDirect;
import com.aliyun.sdk.service.oss2.utils.Base64Utils;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.crypto.SecretKey;

public abstract class CryptoModuleBase
implements CryptoModule {
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    protected final EncryptionMaterials encryptionMaterials;
    protected final CryptoConfiguration cryptoConfig;
    protected final OSSDirect ossDirect;
    protected final String encryptionClientUserAgent;

    protected CryptoModuleBase(OSSDirect ossDirect, EncryptionMaterials encryptionMaterials, CryptoConfiguration cryptoConfig) {
        this.encryptionMaterials = encryptionMaterials;
        this.ossDirect = ossDirect;
        this.cryptoConfig = cryptoConfig;
        this.encryptionClientUserAgent = "";
    }

    abstract SecretKey generateCEK();

    abstract byte[] generateIV();

    abstract String getContentCipherAlgorithm();

    abstract CryptoCipher createEncryptCryptoCipher(ContentCryptoMaterial var1, long[] var2, long var3);

    abstract CryptoCipher createDecryptCryptoCipher(ContentCryptoMaterial var1, long[] var2, long var3);

    protected final Map<String, String> generateCryptoMetadata(ContentCryptoMaterial contentCryptoMaterial, Map<String, Object> headers) {
        TreeMap<String, String> metadata = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        byte[] encryptedCEK = contentCryptoMaterial.getEncryptedCEK();
        metadata.put("client-side-encryption-key", Base64Utils.encodeToString(encryptedCEK));
        byte[] encryptedIV = contentCryptoMaterial.getEncryptedIV();
        metadata.put("client-side-encryption-start", Base64Utils.encodeToString(encryptedIV));
        String contentCryptoAlgo = contentCryptoMaterial.getContentCryptoAlgorithm();
        metadata.put("client-side-encryption-cek-alg", contentCryptoAlgo);
        String keyWrapAlgo = contentCryptoMaterial.getKeyWrapAlgorithm();
        metadata.put("client-side-encryption-wrap-alg", keyWrapAlgo);
        Map<String, String> materialDesc = contentCryptoMaterial.getMaterialsDescription();
        if (materialDesc == null || !materialDesc.isEmpty()) {
            // empty if block
        }
        if (headers.containsKey("Content-MD5")) {
            metadata.put("client-side-encryption-unencrypted-content-md5", (String)headers.get("Content-MD5"));
        }
        return metadata;
    }

    protected final Map<String, String> generateMultiPartCryptoMetadata(ContentCryptoMaterial contentCryptoMaterial, Map<String, Object> headers, Long partSize, Long dataSize) {
        Map<String, String> metaData = this.generateCryptoMetadata(contentCryptoMaterial, headers);
        metaData.put("client-side-encryption-part-size", partSize.toString());
        if (dataSize != null) {
            metaData.put("client-side-encryption-data-size", dataSize.toString());
        }
        return metaData;
    }

    protected ContentCryptoMaterial createContentCryptoMaterialDefault() {
        byte[] iv = this.generateIV();
        SecretKey cek = this.generateCEK();
        ContentCryptoMaterial contentMaterial = new ContentCryptoMaterial();
        contentMaterial.setIV(iv);
        contentMaterial.setCEK(cek);
        contentMaterial.setContentCryptoAlgorithm(this.getContentCipherAlgorithm());
        this.encryptionMaterials.encryptCEK(contentMaterial);
        return contentMaterial;
    }

    protected ContentCryptoMaterial createContentMaterialFromMetadata(Map<String, String> headers) {
        String b64CEK = headers.get("x-oss-meta-client-side-encryption-key");
        String b64IV = headers.get("x-oss-meta-client-side-encryption-start");
        if (b64CEK == null || b64IV == null) {
            throw new RuntimeException("Content encrypted key  or encrypted iv not found.", null);
        }
        byte[] encryptedCEK = Base64Utils.decodeString(b64CEK);
        byte[] encryptedIV = Base64Utils.decodeString(b64IV);
        String keyWrapAlgo = headers.get("x-oss-meta-client-side-encryption-wrap-alg");
        if (keyWrapAlgo == null) {
            throw new RuntimeException("Key wrap algorithm should not be null.", null);
        }
        String cekAlgo = headers.get("x-oss-meta-client-side-encryption-cek-alg");
        String mateDescString = headers.get("x-oss-meta-client-side-encryption-matdesc");
        Map<String, String> matDesc = CryptoUtils.getDescFromJsonString(mateDescString);
        ContentCryptoMaterial contentMaterial = new ContentCryptoMaterial();
        contentMaterial.setEncryptedCEK(encryptedCEK);
        contentMaterial.setEncryptedIV(encryptedIV);
        contentMaterial.setMaterialsDescription(matDesc);
        contentMaterial.setContentCryptoAlgorithm(cekAlgo);
        contentMaterial.setKeyWrapAlgorithm(keyWrapAlgo);
        this.encryptionMaterials.decryptCEK(contentMaterial);
        return contentMaterial;
    }

    private void checkMultipartPartSize(Long partSize) {
        Objects.requireNonNull(partSize, "PartSize");
        if (partSize <= 0L || 0L != partSize % 16L) {
            throw new IllegalArgumentException("PartSize is not 16 bytes alignment.");
        }
    }
}

