/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.encryption.internal;

import java.util.HashMap;
import java.util.Map;

public class CryptoUtils {
    private static final String RANGE_PREFIX = "bytes=";

    public static boolean hasEncryptionInfo(Map<String, String> headers) {
        return headers != null && headers.containsKey("x-oss-meta-client-side-encryption-key") && headers.containsKey("x-oss-meta-client-side-encryption-start");
    }

    public static Map<String, String> getDescFromJsonString(String jsonString) {
        HashMap<String, String> map = new HashMap<String, String>();
        return map;
    }

    public static long[] parseRange(String range) {
        String oriRange = range;
        if (range == null) {
            return null;
        }
        if (!range.startsWith(RANGE_PREFIX)) {
            throw new RuntimeException("Range does not start with bytes=", null);
        }
        range = range.substring(6);
        long lstart = -1L;
        long lend = -1L;
        try {
            String end;
            String start = range.substring(0, range.indexOf(45));
            if (!start.isEmpty()) {
                lstart = Long.parseLong(start);
            }
            if (!(end = range.substring(range.indexOf(45) + 1)).isEmpty()) {
                lend = Long.parseLong(end);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Parse range fail", e);
        }
        if (lstart < 0L && lend < 0L || lstart > 0L && lend > 0L && lstart > lend) {
            throw new RuntimeException("Invalid range value " + oriRange, null);
        }
        return new long[]{lstart, lend};
    }

    public static String toRangeString(long[] range) {
        if (range == null || range.length != 2) {
            return null;
        }
        long start = range[0];
        long end = range[1];
        if (start < 0L && end < 0L || start > 0L && end > 0L && start > end) {
            return null;
        }
        if (start < 0L) {
            return String.format("%s-%d", RANGE_PREFIX, end);
        }
        if (end < 0L) {
            return String.format("%s%d-", RANGE_PREFIX, start);
        }
        return String.format("%s%d-%d", RANGE_PREFIX, start, end);
    }

    public static long[] calcCryptoRange(long[] range) {
        if (range == null) {
            return null;
        }
        if (range[0] < 0L && range[1] < 0L || range[0] > 0L && range[1] > 0L && range[0] > range[1]) {
            throw new RuntimeException("The range is illegal. + range:" + range[0] + "~" + range[1], null);
        }
        long[] adjustedCryptoRange = new long[]{range[0] < 0L ? range[0] : range[0] / 16L * 16L, range[1]};
        return adjustedCryptoRange;
    }
}

