/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.encryption.internal;

import com.aliyun.sdk.service.oss2.encryption.crypto.CryptoCipher;
import com.aliyun.sdk.service.oss2.encryption.internal.CipherInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class RenewableCipherInputStream
extends CipherInputStream {
    private boolean hasBeenAccessed;

    public RenewableCipherInputStream(InputStream is, CryptoCipher cryptoCipher) {
        super(is, cryptoCipher);
    }

    public RenewableCipherInputStream(InputStream is, CryptoCipher c, int buffsize) {
        super(is, c, buffsize);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void mark(int readlimit) {
        if (this.hasBeenAccessed) {
            throw new UnsupportedOperationException("Marking is only supported before your first call to read or skip.");
        }
        this.in.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.renewCryptoCipher();
        this.resetInternal();
        this.hasBeenAccessed = false;
    }

    @Override
    public int read() throws IOException {
        this.hasBeenAccessed = true;
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.hasBeenAccessed = true;
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.hasBeenAccessed = true;
        return super.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.hasBeenAccessed = true;
        return super.skip(n);
    }
}

