/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.exceptions;

import com.aliyun.sdk.service.oss2.utils.MapUtils;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;

public class ServiceException
extends RuntimeException {
    public static final String ERROR_FMT = "Error returned by Service.\nHttp Status Code: %d.\nError Code: %s.\nRequest Id: %s.\nMessage: %s.\nEC: %s.\nTimestamp: %s.\nRequest Endpoint: %s.";
    private final int statusCode;
    private final Map<String, String> headers;
    private final Map<String, String> errorFields;
    private final String requestTarget;
    private final byte[] snapshot;
    private final Instant timestamp;

    private ServiceException(Builder builder) {
        super(String.format(ERROR_FMT, builder.statusCode, ServiceException.toErrorCode(builder.errorFields), ServiceException.toRequestId(builder.errorFields, builder.headers), ServiceException.toErrorMessage(builder.errorFields), ServiceException.toEc(builder.errorFields, builder.headers), builder.timestamp, builder.requestTarget));
        this.statusCode = builder.statusCode;
        this.headers = Optional.ofNullable(builder.headers).orElse(MapUtils.caseInsensitiveMap());
        this.errorFields = Optional.ofNullable(builder.errorFields).orElse(MapUtils.caseSensitiveMap());
        this.snapshot = builder.snapshot;
        this.timestamp = Optional.ofNullable(builder.timestamp).orElse(Instant.now());
        this.requestTarget = Optional.ofNullable(builder.requestTarget).orElse("");
    }

    public static ServiceException asCause(Throwable chain) {
        if (chain == null) {
            return null;
        }
        for (Throwable current = chain; current != null; current = current.getCause()) {
            if (!(current instanceof ServiceException)) continue;
            return (ServiceException)current;
        }
        return null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static String toErrorCode(Map<String, String> errorFields) {
        if (errorFields == null) {
            return "BadErrorResponse";
        }
        return errorFields.getOrDefault("Code", "BadErrorResponse");
    }

    private static String toErrorMessage(Map<String, String> errorFields) {
        if (errorFields == null) {
            return "";
        }
        return errorFields.getOrDefault("Message", "");
    }

    private static String toRequestId(Map<String, String> errorFields, Map<String, String> headers) {
        String value = null;
        if (errorFields != null) {
            value = errorFields.get("RequestId");
        }
        if (value == null && headers != null) {
            value = headers.get("x-oss-request-id");
        }
        return Optional.ofNullable(value).orElse("");
    }

    private static String toEc(Map<String, String> errorFields, Map<String, String> headers) {
        String value = null;
        if (errorFields != null) {
            value = errorFields.get("EC");
        }
        if (value == null && headers != null) {
            value = headers.get("x-oss-ec");
        }
        return Optional.ofNullable(value).orElse("");
    }

    public int statusCode() {
        return this.statusCode;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public Map<String, String> errorFields() {
        return this.errorFields;
    }

    public String requestTarget() {
        return this.requestTarget;
    }

    public byte[] snapshot() {
        return this.snapshot;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public String errorCode() {
        return ServiceException.toErrorCode(this.errorFields);
    }

    public String errorMessage() {
        return ServiceException.toErrorMessage(this.errorFields);
    }

    public String requestId() {
        return ServiceException.toRequestId(this.errorFields, this.headers);
    }

    public String ec() {
        return ServiceException.toEc(this.errorFields, this.headers);
    }

    public static class Builder {
        private int statusCode;
        private Map<String, String> headers;
        private Map<String, String> errorFields;
        private String requestTarget;
        private byte[] snapshot;
        private Instant timestamp;

        private Builder() {
        }

        private Builder(ServiceException from) {
            this.statusCode = from.statusCode;
            this.headers = from.headers;
            this.errorFields = from.errorFields;
            this.requestTarget = from.requestTarget;
            this.snapshot = from.snapshot;
            this.timestamp = from.timestamp;
        }

        public Builder statusCode(int value) {
            this.statusCode = value;
            return this;
        }

        public Builder headers(Map<String, String> value) {
            this.headers = value;
            return this;
        }

        public Builder errorFields(Map<String, String> value) {
            this.errorFields = value;
            return this;
        }

        public Builder requestTarget(String value) {
            this.requestTarget = value;
            return this;
        }

        public Builder snapshot(byte[] value) {
            this.snapshot = value;
            return this;
        }

        public Builder timestamp(Instant value) {
            this.timestamp = value;
            return this;
        }

        public ServiceException build() {
            return new ServiceException(this);
        }
    }
}

