/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.internal;

import com.aliyun.sdk.service.oss2.io.StreamObserver;
import com.aliyun.sdk.service.oss2.transport.ObservableByteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ByteChannelObserver
implements ObservableByteChannel {
    private final StreamObserver so;
    private final WritableByteChannel wbc;
    private byte[] tempArray;

    public ByteChannelObserver(StreamObserver so) {
        this.so = so;
        this.wbc = so instanceof ObservableByteChannel ? (WritableByteChannel)((Object)so) : null;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.wbc != null) {
            return this.wbc.write(src);
        }
        int first = src.position();
        this.dataUpdate(src);
        return src.position() - first;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    protected void dataUpdate(ByteBuffer input) throws IOException {
        if (!input.hasRemaining()) {
            return;
        }
        if (input.hasArray()) {
            byte[] b = input.array();
            int ofs = input.arrayOffset();
            int pos = input.position();
            int lim = input.limit();
            this.so.data(b, ofs + pos, lim - pos);
            input.position(lim);
        } else {
            int len = input.remaining();
            int n = Math.min(4096, len);
            if (this.tempArray == null || n > this.tempArray.length) {
                this.tempArray = new byte[n];
            }
            while (len > 0) {
                int chunk = Math.min(len, this.tempArray.length);
                input.get(this.tempArray, 0, chunk);
                this.so.data(this.tempArray, 0, chunk);
                len -= chunk;
            }
        }
    }

    @Override
    public void finished() throws IOException {
        this.so.finished();
    }
}

