/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.internal;

import com.aliyun.sdk.service.oss2.AttributeKey;
import com.aliyun.sdk.service.oss2.ClientConfiguration;
import com.aliyun.sdk.service.oss2.ClientOptions;
import com.aliyun.sdk.service.oss2.Defaults;
import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOptions;
import com.aliyun.sdk.service.oss2.OperationOutput;
import com.aliyun.sdk.service.oss2.credentials.AnonymousCredentialsProvider;
import com.aliyun.sdk.service.oss2.credentials.Credentials;
import com.aliyun.sdk.service.oss2.credentials.CredentialsProvider;
import com.aliyun.sdk.service.oss2.exceptions.CredentialsException;
import com.aliyun.sdk.service.oss2.exceptions.OperationException;
import com.aliyun.sdk.service.oss2.exceptions.PresignExpirationException;
import com.aliyun.sdk.service.oss2.exceptions.ServiceException;
import com.aliyun.sdk.service.oss2.internal.Ensure;
import com.aliyun.sdk.service.oss2.internal.ExecuteContext;
import com.aliyun.sdk.service.oss2.internal.ExecuteMiddleware;
import com.aliyun.sdk.service.oss2.internal.ExecuteStack;
import com.aliyun.sdk.service.oss2.internal.OssUtils;
import com.aliyun.sdk.service.oss2.internal.Pair;
import com.aliyun.sdk.service.oss2.internal.ResponseCheckerExecuteMiddleware;
import com.aliyun.sdk.service.oss2.internal.RetryerExecuteMiddleware;
import com.aliyun.sdk.service.oss2.internal.SignerExecuteMiddleware;
import com.aliyun.sdk.service.oss2.internal.TransportExecuteMiddleware;
import com.aliyun.sdk.service.oss2.io.StreamObserver;
import com.aliyun.sdk.service.oss2.retry.Retryer;
import com.aliyun.sdk.service.oss2.retry.StandardRetryer;
import com.aliyun.sdk.service.oss2.signer.Signer;
import com.aliyun.sdk.service.oss2.signer.SignerV1;
import com.aliyun.sdk.service.oss2.signer.SignerV4;
import com.aliyun.sdk.service.oss2.signer.SigningContext;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.transport.ByteArrayBinaryData;
import com.aliyun.sdk.service.oss2.transport.HttpClient;
import com.aliyun.sdk.service.oss2.transport.RequestMessage;
import com.aliyun.sdk.service.oss2.transport.ResponseMessage;
import com.aliyun.sdk.service.oss2.transport.apache5client.Apache5AsyncHttpClient;
import com.aliyun.sdk.service.oss2.transport.apache5client.Apache5HttpClient;
import com.aliyun.sdk.service.oss2.transport.apache5client.Apache5MixedHttpClient;
import com.aliyun.sdk.service.oss2.types.AddressStyleType;
import com.aliyun.sdk.service.oss2.types.AuthMethodType;
import com.aliyun.sdk.service.oss2.types.FeatureFlagsType;
import com.aliyun.sdk.service.oss2.utils.Base64Utils;
import com.aliyun.sdk.service.oss2.utils.DateUtils;
import com.aliyun.sdk.service.oss2.utils.HttpUtils;
import com.aliyun.sdk.service.oss2.utils.InetAddressUtils;
import com.aliyun.sdk.service.oss2.utils.JsonUtils;
import com.aliyun.sdk.service.oss2.utils.MapUtils;
import com.aliyun.sdk.service.oss2.utils.StringUtils;
import com.aliyun.sdk.service.oss2.utils.VersionInfoUtils;
import com.aliyun.sdk.service.oss2.utils.XmlUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public class ClientImpl
implements AutoCloseable {
    private static final OperationOptions defaultPresignOpOpt = OperationOptions.newBuilder().authMethod(AuthMethodType.Query).build();
    final ClientOptions options;
    final InnerOptions innerOptions;
    final ExecuteStack executeStack;

    public ClientImpl(ClientConfiguration config) {
        this(config, new ArrayList<Function<ClientOptions, ClientOptions>>());
    }

    public ClientImpl(ClientConfiguration config, Collection<Function<ClientOptions, ClientOptions>> optFns) {
        ClientOptions opts = this.resolveConfig(config);
        for (Function<ClientOptions, ClientOptions> fn : optFns) {
            opts = fn.apply(opts);
        }
        this.options = opts;
        InnerOptions innerOpts = new InnerOptions();
        innerOpts.setUserAgent(this.resolveUserAgent(config));
        this.innerOptions = innerOpts;
        TransportExecuteMiddleware transport = new TransportExecuteMiddleware(opts.httpClient());
        ExecuteStack stack = new ExecuteStack(transport);
        stack.push(x -> new RetryerExecuteMiddleware((ExecuteMiddleware)x, this.options.retryer()), "Retryer");
        stack.push(x -> new SignerExecuteMiddleware((ExecuteMiddleware)x, this.options.signer(), this.options.credentialsProvider()), "Signer");
        stack.push(ResponseCheckerExecuteMiddleware::new, "ResponseChecker");
        this.executeStack = stack;
    }

    @Override
    public void close() throws Exception {
        HttpClient httpClient = this.options.httpClient();
        if (httpClient instanceof AutoCloseable) {
            ((AutoCloseable)((Object)httpClient)).close();
        }
    }

    public OperationOutput execute(OperationInput input, OperationOptions opts) {
        this.verifyOperation(input);
        Pair<RequestMessage, ExecuteContext> ctx = this.buildRequestContext(input, opts);
        try {
            ResponseMessage response = this.executeStack.execute(ctx.first(), ctx.second());
            return OperationOutput.newBuilder().input(input).statusCode(response.statusCode()).headers(response.headers()).body(response.body()).build();
        }
        catch (Exception e) {
            throw new OperationException(input.opName(), e);
        }
    }

    public CompletableFuture<OperationOutput> executeAsync(OperationInput input, OperationOptions opts) {
        CompletableFuture<OperationOutput> future = new CompletableFuture<OperationOutput>();
        try {
            this.verifyOperation(input);
            Pair<RequestMessage, ExecuteContext> ctx = this.buildRequestContext(input, opts);
            this.executeStack.executeAsync(ctx.first(), ctx.second()).whenComplete((response, exception) -> {
                if (exception != null) {
                    future.completeExceptionally(new OperationException(input.opName(), (Throwable)exception));
                } else {
                    future.complete(OperationOutput.newBuilder().input(input).statusCode(response.statusCode()).headers(response.headers()).body(response.body()).build());
                }
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public PresignInnerResult presignInner(OperationInput input, OperationOptions opts) {
        this.verifyOperation(input);
        opts = Optional.ofNullable(opts).orElse(defaultPresignOpOpt);
        Pair<RequestMessage, ExecuteContext> ctx = this.buildRequestContext(input, opts);
        CredentialsProvider provider = this.options.credentialsProvider();
        PresignInnerResult result = new PresignInnerResult();
        RequestMessage request = ctx.first();
        if (provider != null && !(provider instanceof AnonymousCredentialsProvider) && ctx.second().signingContext != null) {
            Credentials cred = provider.getCredentials();
            Signer signer = this.options.signer();
            if (cred == null || !cred.hasKeys()) {
                throw new CredentialsException("Credentials is null or empty.");
            }
            ctx.second().signingContext.setCredentials(cred);
            ctx.second().signingContext.setRequest(request);
            signer.sign(ctx.second().signingContext);
            request = ctx.second().signingContext.getRequest();
            result.expiration = ctx.second().signingContext.getExpiration();
            ArrayList<String> expect = new ArrayList<String>();
            expect.add("content-type");
            expect.add("content-md5");
            if (signer instanceof SignerV4) {
                Instant nowTo7Days;
                List<String> addHeaders = ctx.second().signingContext.getAdditionalHeaders();
                if (addHeaders != null) {
                    addHeaders.forEach(x -> expect.add(x.toLowerCase()));
                }
                if (result.expiration.isAfter(nowTo7Days = Instant.now().plusSeconds(604800L))) {
                    throw new PresignExpirationException();
                }
            }
            Map<String, String> signedHeaders = MapUtils.caseInsensitiveMap();
            request.headers().forEach((h, v) -> {
                String low = h.toLowerCase();
                if (expect.contains(low) || low.startsWith("x-oss-")) {
                    signedHeaders.put((String)h, (String)v);
                }
            });
            result.signedHeaders = signedHeaders;
        }
        result.url = request.uri().toString();
        result.method = request.method();
        return result;
    }

    public int getFeatureFlags() {
        return this.options.featureFlags();
    }

    private void verifyOperation(OperationInput input) {
        String key;
        String bucket;
        if (this.options.endpoint() == null) {
            throw new IllegalArgumentException("endpoint or region is invalid");
        }
        if (StringUtils.isNullOrEmpty(input.method())) {
            throw new IllegalArgumentException("input.method is null or empty");
        }
        if (input.bucket().isPresent() && !Ensure.isValidateBucketName(bucket = input.bucket().get())) {
            throw new IllegalArgumentException("input.bucket is invalid, got " + bucket + ".");
        }
        if (input.key().isPresent() && !Ensure.isValidateObjectName(key = input.key().get())) {
            throw new IllegalArgumentException("input.key is invalid, got " + key + ".");
        }
    }

    private Pair<RequestMessage, ExecuteContext> buildRequestContext(OperationInput input, OperationOptions opOpts) {
        if (opOpts == null) {
            opOpts = OperationOptions.defaults();
        }
        ExecuteContext context = new ExecuteContext();
        context.retryMaxAttempts = opOpts.retryMaxAttempts().orElse(this.options.retryer().maxAttempts());
        if (input.opMetadata().containsKey(AttributeKey.UPLOAD_OBSERVER)) {
            context.requestBodyObserver = new ArrayList<StreamObserver>();
            context.requestBodyObserver.addAll((Collection<StreamObserver>)input.opMetadata().get(AttributeKey.UPLOAD_OBSERVER));
        }
        context.onResponseMessage = new ArrayList<Consumer<ResponseMessage>>();
        context.onResponseMessage.add(OnServiceError.INSTANCE);
        if (input.opMetadata().containsKey(AttributeKey.RESPONSE_HANDLER)) {
            context.onResponseMessage.addAll((Collection<Consumer<ResponseMessage>>)input.opMetadata().get(AttributeKey.RESPONSE_HANDLER));
        }
        if (input.opMetadata().containsKey(AttributeKey.RESPONSE_HEADERS_READ)) {
            context.responseHeadersRead = Boolean.TRUE;
        }
        if (input.opMetadata().containsKey(AttributeKey.RESPONSE_CONSUMER_SUPPLIER)) {
            context.dataConsumerSupplier = input.opMetadata().get(AttributeKey.RESPONSE_CONSUMER_SUPPLIER);
        }
        AuthMethodType authMethod = opOpts.authMethod().orElse(this.options.authMethod());
        SigningContext signCtx = new SigningContext();
        signCtx.setProduct(this.options.product());
        signCtx.setRegion(this.options.region());
        signCtx.setBucket(input.bucket().orElse(""));
        signCtx.setKey(input.key().orElse(""));
        signCtx.setAuthMethodQuery(authMethod == AuthMethodType.Query);
        signCtx.setSubResource(input.opMetadata().get(AttributeKey.SUBRESOURCE));
        signCtx.setAdditionalHeaders(this.options.additionalHeaders());
        if (input.opMetadata().containsKey(AttributeKey.EXPIRATION_TIME)) {
            signCtx.setExpiration(input.opMetadata().get(AttributeKey.EXPIRATION_TIME));
        }
        context.signingContext = signCtx;
        StringBuilder url = new StringBuilder();
        if (this.options.endpointProvider() != null) {
            url.append(this.options.endpointProvider().buildURL(input));
        } else {
            URI endpoint = this.options.endpoint();
            url.append(endpoint.getScheme()).append("://");
            url.append(OssUtils.buildHostPath(input, endpoint.getAuthority(), this.options.addressStyle()));
        }
        Optional<String> query = HttpUtils.encodeQueryParameters(input.parameters());
        query.ifPresent(s -> url.append("?").append((String)s));
        Map<String, String> headers = input.headers();
        headers.put("User-Agent", this.innerOptions.getUserAgent());
        BinaryData body = input.body().orElse(new ByteArrayBinaryData(new byte[0]));
        RequestMessage request = RequestMessage.newBuilder().method(input.method()).uri(url.toString()).headers(headers).body(body).build();
        return new Pair<RequestMessage, ExecuteContext>(request, context);
    }

    private ClientOptions resolveConfig(ClientConfiguration config) {
        if (!config.credentialsProvider().isPresent()) {
            throw new IllegalArgumentException("credentialsProvider is null");
        }
        URI endpoint = this.resolveEndpoint(config);
        return new ClientOptions.Builder().product("oss").region(config.region().orElse("")).endpoint(endpoint).retryer(this.resolveRetryer(config)).signer(this.resolveSigner(config)).credentialsProvider(config.credentialsProvider().get()).httpClient(this.resolveHttpClient(config)).addressStyle(this.resolveAddressStyle(config, endpoint)).authMethod(AuthMethodType.Header).additionalHeaders(config.additionalHeaders().orElse(Collections.emptyList())).featureFlags(this.resolveFeatureFlags(config)).build();
    }

    private URI resolveEndpoint(ClientConfiguration config) {
        if (!config.region().isPresent() && !config.endpoint().isPresent()) {
            return null;
        }
        boolean disableSsl = config.disableSsl().orElse(Defaults.DisableSsl);
        String endpoint = config.endpoint().orElse("");
        String region = config.region().orElse("");
        if (config.endpoint().isPresent()) {
            endpoint = OssUtils.addScheme(endpoint, disableSsl);
        } else if (Ensure.isValidRegion(region)) {
            OssUtils.EndpointType type = config.useDualStackEndpoint().orElse(false) != false ? OssUtils.EndpointType.DualStack : (config.useInternalEndpoint().orElse(false) != false ? OssUtils.EndpointType.Internal : (config.useAccelerateEndpoint().orElse(false) != false ? OssUtils.EndpointType.Accelerate : OssUtils.EndpointType.Default));
            endpoint = OssUtils.regionToEndpoint(region, type, disableSsl);
        }
        try {
            URI uri = new URI(endpoint);
            return uri.getHost() == null ? null : uri;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private AddressStyleType resolveAddressStyle(ClientConfiguration config, URI endpoint) {
        AddressStyleType style = config.useCName().orElse(false) != false ? AddressStyleType.CName : (config.usePathStyle().orElse(false) != false ? AddressStyleType.Path : AddressStyleType.VirtualHosted);
        if (endpoint != null && (InetAddressUtils.isValid(endpoint.getHost()) || endpoint.getHost().equals("localhost"))) {
            style = AddressStyleType.Path;
        }
        return style;
    }

    private Retryer resolveRetryer(ClientConfiguration config) {
        return config.retryer().orElseGet(() -> StandardRetryer.newBuilder().maxAttempts(config.retryMaxAttempts().orElse(3)).build());
    }

    private Signer resolveSigner(ClientConfiguration config) {
        return config.signer().orElseGet(() -> {
            if (config.signatureVersion().orElse("v4").equals("v1")) {
                return new SignerV1();
            }
            return new SignerV4();
        });
    }

    private HttpClient resolveHttpClient(ClientConfiguration config) {
        return config.httpClient().orElseGet(() -> new Apache5MixedHttpClient(Apache5HttpClient.custom().build(), Apache5AsyncHttpClient.custom().build()));
    }

    private String resolveUserAgent(ClientConfiguration config) {
        String ua = VersionInfoUtils.getDefaultUserAgent();
        if (this.options.httpClient() != null) {
            ua = ua + "/" + this.options.httpClient().name();
        }
        if (config.userAgent().isPresent()) {
            ua = ua + "/" + config.userAgent().get();
        }
        return ua;
    }

    private int resolveFeatureFlags(ClientConfiguration config) {
        int flags = Defaults.FEATURE_FLAGS;
        if (config.DisableUploadCRC64Check().orElse(false).booleanValue()) {
            flags = ~FeatureFlagsType.ENABLE_CRC64_CHECK_UPLOAD.getValue() & flags;
        }
        return flags;
    }

    static class OnServiceError
    implements Consumer<ResponseMessage> {
        public static OnServiceError INSTANCE = new OnServiceError();

        OnServiceError() {
        }

        @Override
        public void accept(ResponseMessage response) {
            byte[] data;
            int statusCode;
            Map<String, String> errorFields;
            Map<String, String> headers;
            block20: {
                Iterator iterator;
                JsonNode root;
                headers = Optional.ofNullable(response.headers()).orElse(MapUtils.caseInsensitiveMap());
                errorFields = MapUtils.caseSensitiveMap();
                statusCode = response.statusCode();
                if (statusCode / 100 == 2) {
                    return;
                }
                byte[] byArray = data = response.body() != null ? response.body().toBytes() : null;
                if ((data == null || data.length == 0) && headers.containsKey("x-oss-err")) {
                    data = Base64Utils.decodeString(headers.get("x-oss-err"));
                }
                data = Optional.ofNullable(data).orElse(new byte[0]);
                if ("application/json".equals(headers.get("Content-Type"))) {
                    try {
                        if (data.length > 0) {
                            root = JsonUtils.getJsonRootElement(data);
                            if (root.has("Error")) {
                                iterator = root.get("Error").fields();
                                while (iterator.hasNext()) {
                                    Map.Entry entry = (Map.Entry)iterator.next();
                                    errorFields.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
                                }
                            } else {
                                errorFields.put("Message", this.toErrorMessage("Not found key Error", data));
                            }
                            break block20;
                        }
                        errorFields.put("Message", this.toErrorMessage("Empty body", data));
                    }
                    catch (Exception ignored) {
                        errorFields.put("Message", this.toErrorMessage("Failed to parse json from response body", data));
                    }
                } else {
                    try {
                        if (data.length > 0) {
                            root = XmlUtils.getXmlRootElement(data);
                            if (root.has("Error")) {
                                iterator = root.get("Error").fields();
                                while (iterator.hasNext()) {
                                    Map.Entry entry = (Map.Entry)iterator.next();
                                    errorFields.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
                                }
                            } else {
                                errorFields.put("Message", this.toErrorMessage("Not found tag <Error>", data));
                            }
                        } else {
                            errorFields.put("Message", this.toErrorMessage("Empty body", data));
                        }
                    }
                    catch (Exception ignored) {
                        errorFields.put("Message", this.toErrorMessage("Failed to parse xml from response body", data));
                    }
                }
            }
            Instant ts = null;
            try {
                ts = DateUtils.parseRfc822Date(headers.get("Date"));
            }
            catch (Exception iterator) {
                // empty catch block
            }
            String requestTarget = null;
            if (response.request() != null) {
                requestTarget = String.format("%s %s", response.request().method(), response.request().uri());
            }
            throw ServiceException.newBuilder().statusCode(statusCode).errorFields(errorFields).headers(headers).snapshot(data).requestTarget(requestTarget).timestamp(ts).build();
        }

        private String toErrorMessage(String prefix, byte[] data) {
            if (data == null || data.length == 0) {
                return prefix;
            }
            String rawString = new String(data);
            return prefix + ", part response body " + rawString.substring(0, Math.min(255, rawString.length()));
        }
    }

    public static class PresignInnerResult {
        public String url;
        public String method;
        public Instant expiration;
        public Map<String, String> signedHeaders;
    }

    public static class InnerOptions {
        private String userAgent;

        public String getUserAgent() {
            return this.userAgent;
        }

        public void setUserAgent(String value) {
            this.userAgent = value;
        }
    }
}

