/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.internal;

import com.aliyun.sdk.service.oss2.internal.ExecuteContext;
import com.aliyun.sdk.service.oss2.internal.ExecuteMiddleware;
import com.aliyun.sdk.service.oss2.internal.TransportExecuteMiddleware;
import com.aliyun.sdk.service.oss2.transport.RequestMessage;
import com.aliyun.sdk.service.oss2.transport.ResponseMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class ExecuteStack {
    private final TransportExecuteMiddleware transport;
    private final List<Function<ExecuteMiddleware, ExecuteMiddleware>> stack;
    private volatile ExecuteMiddleware cached;

    public ExecuteStack(TransportExecuteMiddleware transport) {
        this.transport = transport;
        this.stack = new ArrayList<Function<ExecuteMiddleware, ExecuteMiddleware>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExecuteMiddleware resolve() {
        if (this.cached != null) return this.cached;
        Class<ExecuteStack> clazz = ExecuteStack.class;
        synchronized (ExecuteStack.class) {
            if (this.cached != null) return this.cached;
            ExecuteMiddleware prev = this.transport;
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                prev = this.stack.get(i).apply(prev);
            }
            this.cached = prev;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.cached;
        }
    }

    public void push(Function<ExecuteMiddleware, ExecuteMiddleware> create, String __) {
        this.stack.add(create);
        this.cached = null;
    }

    public ResponseMessage execute(RequestMessage request, ExecuteContext context) throws Exception {
        ExecuteMiddleware handler = this.resolve();
        return handler.execute(request, context);
    }

    public CompletableFuture<ResponseMessage> executeAsync(RequestMessage request, ExecuteContext context) {
        ExecuteMiddleware handler = this.resolve();
        return handler.executeAsync(request, context);
    }
}

