/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.internal;

import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.types.AddressStyleType;
import com.aliyun.sdk.service.oss2.utils.HttpUtils;
import java.util.ArrayList;

final class OssUtils {
    OssUtils() {
    }

    public static String addScheme(String value, boolean disableSsl) {
        if (value != null && !value.matches("^[^:]+://.*")) {
            String scheme = disableSsl ? "http" : "https";
            return scheme + "://" + value;
        }
        return value;
    }

    public static String regionToEndpoint(String value, EndpointType type, boolean disableSsl) {
        String endpoint;
        String scheme = disableSsl ? "http" : "https";
        switch (type) {
            case DualStack: {
                endpoint = String.format("%s.oss.aliyuncs.com", value);
                break;
            }
            case Internal: {
                endpoint = String.format("oss-%s-internal.aliyuncs.com", value);
                break;
            }
            case Accelerate: {
                endpoint = "oss-accelerate.aliyuncs.com";
                break;
            }
            case Overseas: {
                endpoint = "oss-accelerate-overseas.aliyuncs.com";
                break;
            }
            default: {
                endpoint = String.format("oss-%s.aliyuncs.com", value);
            }
        }
        return String.format("%s://%s", scheme, endpoint);
    }

    public static String buildHostPath(OperationInput input, String baseUrl, AddressStyleType style) {
        ArrayList<String> paths = new ArrayList<String>();
        String host = baseUrl;
        if (input.bucket().isPresent()) {
            switch (style) {
                case Path: {
                    paths.add(input.bucket().get());
                    if (input.key().isPresent()) break;
                    paths.add("");
                    break;
                }
                case CName: {
                    break;
                }
                case VirtualHosted: {
                    host = String.format("%s.%s", input.bucket().get(), host);
                }
            }
        }
        if (input.key().isPresent()) {
            paths.add(HttpUtils.urlEncodePath(input.key().get()));
        }
        return String.format("%s/%s", host, String.join((CharSequence)"/", paths));
    }

    static enum EndpointType {
        Default,
        DualStack,
        Internal,
        Accelerate,
        Overseas;

    }
}

