/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.internal;

import com.aliyun.sdk.service.oss2.internal.ExecuteContext;
import com.aliyun.sdk.service.oss2.internal.ExecuteMiddleware;
import com.aliyun.sdk.service.oss2.transport.RequestMessage;
import com.aliyun.sdk.service.oss2.transport.ResponseMessage;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class ResponseCheckerExecuteMiddleware
implements ExecuteMiddleware {
    private final ExecuteMiddleware nextHandler;

    public ResponseCheckerExecuteMiddleware(ExecuteMiddleware nextHandler) {
        this.nextHandler = nextHandler;
    }

    @Override
    public ResponseMessage execute(RequestMessage request, ExecuteContext context) throws Exception {
        return this.onResponseMessage(this.nextHandler.execute(request, context), context);
    }

    @Override
    public CompletableFuture<ResponseMessage> executeAsync(RequestMessage request, ExecuteContext context) {
        return this.nextHandler.executeAsync(request, context).thenApply(response -> this.onResponseMessage((ResponseMessage)response, context));
    }

    private ResponseMessage onResponseMessage(ResponseMessage response, ExecuteContext context) {
        if (context.onResponseMessage != null) {
            for (Consumer<ResponseMessage> consumer : context.onResponseMessage) {
                consumer.accept(response);
            }
        }
        return response;
    }
}

