/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.internal;

import com.aliyun.sdk.service.oss2.internal.ExecuteContext;
import com.aliyun.sdk.service.oss2.internal.ExecuteMiddleware;
import com.aliyun.sdk.service.oss2.io.StreamObserver;
import com.aliyun.sdk.service.oss2.retry.NopRetryer;
import com.aliyun.sdk.service.oss2.retry.Retryer;
import com.aliyun.sdk.service.oss2.transport.RequestMessage;
import com.aliyun.sdk.service.oss2.transport.ResponseMessage;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

class RetryerExecuteMiddleware
implements ExecuteMiddleware {
    private final ExecuteMiddleware nextHandler;
    private final Retryer retryer;

    public RetryerExecuteMiddleware(ExecuteMiddleware nextHandler, Retryer retryer) {
        this.nextHandler = nextHandler;
        this.retryer = Optional.ofNullable(retryer).orElse(new NopRetryer());
    }

    @Override
    public ResponseMessage execute(RequestMessage request, ExecuteContext context) throws Exception {
        int attempts = context.retryMaxAttempts;
        Exception error = null;
        Instant signTime = context.signingContext.getSignTime();
        Instant expirationTime = context.signingContext.getExpiration();
        int retries = 0;
        while (true) {
            try {
                return this.nextHandler.execute(request, context);
            }
            catch (Exception e) {
                block8: {
                    error = e;
                    if (retries + 1 < attempts && (request.body() == null || request.body().isReplayable()) && this.retryer.isErrorRetryable(error)) {
                        Duration delay = this.retryer.retryDelay(retries + 1, error);
                        try {
                            TimeUnit.MILLISECONDS.sleep(delay.toMillis());
                        }
                        catch (InterruptedException e2) {
                            error = e2;
                            break block8;
                        }
                        if (context.requestBodyObserver != null) {
                            for (StreamObserver observer : context.requestBodyObserver) {
                                observer.reset();
                            }
                        }
                        context.signingContext.setSignTime(signTime);
                        context.signingContext.setExpiration(expirationTime);
                        ++retries;
                        continue;
                    }
                }
                throw error;
            }
            break;
        }
    }

    @Override
    public CompletableFuture<ResponseMessage> executeAsync(RequestMessage request, ExecuteContext context) {
        int maxAttempts = context.retryMaxAttempts;
        Instant signTime = context.signingContext.getSignTime();
        CompletableFuture<ResponseMessage> future = new CompletableFuture<ResponseMessage>();
        this.attemptExecuteAsync(future, request, context, 0, maxAttempts, signTime);
        return future;
    }

    private void attemptExecuteAsync(CompletableFuture<ResponseMessage> future, RequestMessage request, ExecuteContext context, int retries, int maxAttempts, Instant signTime) {
        CompletableFuture<ResponseMessage> responseFuture = this.nextHandler.executeAsync(request, context);
        responseFuture.whenComplete((response, exception) -> {
            if (exception != null) {
                Throwable cause = exception.getCause();
                int nextRetries = retries + 1;
                if (nextRetries >= maxAttempts) {
                    future.completeExceptionally((Throwable)exception);
                    return;
                }
                if (request.body() != null && !request.body().isReplayable()) {
                    future.completeExceptionally((Throwable)exception);
                    return;
                }
                if (context.dataConsumerSupplier != null && !context.dataConsumerSupplier.isReplayable()) {
                    future.completeExceptionally((Throwable)exception);
                    return;
                }
                if (!this.retryer.isErrorRetryable(cause)) {
                    future.completeExceptionally((Throwable)exception);
                    return;
                }
                Duration delay = this.retryer.retryDelay(nextRetries, cause);
                try {
                    TimeUnit.MILLISECONDS.sleep(delay.toMillis());
                }
                catch (InterruptedException e) {
                    future.completeExceptionally((Throwable)exception);
                    return;
                }
                if (context.requestBodyObserver != null) {
                    for (StreamObserver observer : context.requestBodyObserver) {
                        observer.reset();
                    }
                }
                context.signingContext.setSignTime(signTime);
                this.attemptExecuteAsync(future, request, context, nextRetries, maxAttempts, signTime);
            } else {
                future.complete((ResponseMessage)response);
            }
        });
    }
}

